package net.mehvahdjukaar.moonlight.core.network;

import com.google.common.base.Preconditions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

@SuppressWarnings("unchecked")
public class ClientBoundSyncWorldDataMessage<D extends WorldSavedData> implements Message {
    private final D data;

    public static final class_9155<class_9129, ClientBoundSyncWorldDataMessage<?>> TYPE = Message.makeType(
            Moonlight.res("s2c_sync_world_data"), ClientBoundSyncWorldDataMessage::fromNetwork);

    public ClientBoundSyncWorldDataMessage(D data) {
        this.data = data;
    }

    private static ClientBoundSyncWorldDataMessage<?> fromNetwork(class_9129 buffer) {
        WorldSavedDataType<?> type = WorldSavedDataType.STREAM_CODEC.decode(buffer);
        return new ClientBoundSyncWorldDataMessage<>(
                Preconditions.checkNotNull(type.getStreamCodec()).decode(buffer));
    }

    @Override
    public void write(class_9129 buf) {
        WorldSavedDataType<WorldSavedData> type = (WorldSavedDataType<WorldSavedData>) this.data.getType();
        WorldSavedDataType.STREAM_CODEC.encode(buf, type);
        Preconditions.checkNotNull(type.getStreamCodec()).encode(buf, this.data);
    }

    @Override
    public void handle(Context context) {
        handleSyncWorldData(this);
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE.comp_2243();
    }

    @Environment(EnvType.CLIENT)
    private static void handleSyncWorldData(ClientBoundSyncWorldDataMessage<?> message) {
        var l = class_310.method_1551().field_1687;
        //assigns data to client
        WorldSavedDataType<WorldSavedData> type = (WorldSavedDataType<WorldSavedData>) message.data.getType();
        type.setData(l, message.data);
        Moonlight.LOGGER.info("Synced Custom World Data [{}]", type.getName());
    }
}
