package net.mehvahdjukaar.moonlight.core.network;

import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import java.io.ByteArrayInputStream;

//bidirectional
public class SyncConfigsMessage implements Message {

    public static final class_9155<class_9129, SyncConfigsMessage> TYPE = Message.makeType(
            Moonlight.res("bidi_sync_configs"), SyncConfigsMessage::new);

    public final class_2960 configId;
    public final byte[] configData;

    public SyncConfigsMessage(class_9129 buf) {
        this.configId = buf.method_10810();
        this.configData = buf.method_10795();
    }

    public SyncConfigsMessage(final byte[] configFileData, final class_2960 configId) {
        this.configId = configId;
        this.configData = configFileData;
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_10812(this.configId);
        buf.method_10813(this.configData);
    }

    @Override
    public void handle(Context context) {
        if (context.getDirection() == NetworkDir.SERVER_BOUND) {
            if (context.getPlayer() instanceof class_3222 sp && !sp.method_5687(3)) {
                Moonlight.LOGGER.warn("Player {} tried to sync their configs without permission", sp.method_5477().getString());
                return;
            }
        }
        var config = ModConfigHolder.getConfigSpec(this.configId);
        if (config != null) {
            try (var stream = new ByteArrayInputStream(this.configData)) {
                config.loadFromBytes(stream);
                Moonlight.LOGGER.info("Synced {} configs", config.getFileName());
            } catch (Exception ignored) {
            }
        } else {
            Moonlight.LOGGER.error("Failed to find config file with id {}", this.configId);
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE.comp_2243();
    }
}
