package net.mehvahdjukaar.moonlight.core.network.fabric;

import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.fabric.IFabricMenuType;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.MenuScreensAccessor;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.MenuTypeAccessor;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.ServerPlayerAccessor;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3917.class_3918;
import net.minecraft.class_3929;
import net.minecraft.class_3929.class_3930;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import java.util.function.Consumer;

public class ClientBoundOpenCustomMenuMessage implements Message {

    public static final class_9155<class_9129, ClientBoundOpenCustomMenuMessage> TYPE = Message.makeType(
            Moonlight.res("s2c_open_menu"), ClientBoundOpenCustomMenuMessage::new);

    private final int containerId;
    private final class_3917<?> type;
    private final class_2561 title;
    private final class_2540 additionalData;

    public ClientBoundOpenCustomMenuMessage(int i, class_3917<?> menuType, class_2561 component, class_2540 additionalData) {
        this.containerId = i;
        this.type = menuType;
        this.title = component;
        this.additionalData = additionalData;
    }

    //replace with fabric screen handler
    public ClientBoundOpenCustomMenuMessage(class_9129 buf) {
        this.containerId = buf.method_10816();
        this.type = buf.method_52962(class_7923.field_41187::method_10200);
        this.title = class_8824.field_48540.decode(buf);

        this.additionalData = new class_2540(Unpooled.wrappedBuffer(buf.method_10803(32600)));
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_10804(this.containerId);
        buf.method_52963(class_7923.field_41187::method_10206, this.type);
        class_8824.field_48540.encode(buf, this.title);

        buf.method_10813(this.additionalData.method_10795());
    }

    @Override
    public void handle(Context context) {
        clientHandle();
    }

    //TODO: use fabric api stuff
    @Environment(EnvType.CLIENT)
    private void clientHandle() {
        try {
            var constructor = MenuScreensAccessor.invokeGetConstructor(this.type);

            class_1661 inventory = class_310.method_1551().field_1724.method_31548();

            class_1703 menu;

            var containerConstructor = ((MenuTypeAccessor<?>) type).getConstructor();

            if (containerConstructor instanceof IFabricMenuType.Factory customFactory) {
                menu = customFactory.create(containerId, inventory, additionalData);
            } else {
                menu = type.method_17434(containerId, class_310.method_1551().field_1724.method_31548());
            }
            @SuppressWarnings("unchecked")
            class_437 screen = ((class_3929.class_3930<class_1703, ?>) constructor).create(menu, inventory, title);

            class_310.method_1551().field_1724.field_7512 = ((class_3936<?>) screen).method_17577();
            class_310.method_1551().method_1507(screen);

        } finally {
            this.additionalData.release();
        }
    }


    public static void openMenu(class_3222 player, class_3908 menuProvider, Consumer<class_9129> extraDataWriter) {
        if (player.field_7512 != player.field_7498) {
            player.method_7346();
        }
        var p = ((ServerPlayerAccessor) player);

        p.invokeNextContainerCounter();
        class_1703 containerMenu = menuProvider.createMenu(p.getContainerCounter(), player.method_31548(), player);
        if (containerMenu == null) {
            if (player.method_7325()) {
                player.method_7353(class_2561.method_43471("container.spectatorCantOpen").method_27692(class_124.field_1061), true);
            }
        } else {
            class_9129 extraData = new class_9129(Unpooled.buffer(), player.method_37908().method_30349());
            extraDataWriter.accept(extraData);
            extraData.method_52988(0);
            class_2540 output = new class_2540(Unpooled.buffer());
            output.method_10804(extraData.readableBytes());
            output.method_52975(extraData);

            NetworkHelper.sendToClientPlayer(player, new ClientBoundOpenCustomMenuMessage(containerMenu.field_7763,
                    containerMenu.method_17358(), menuProvider.method_5476(), output));

            p.invokeInitMenu(containerMenu);
            player.field_7512 = containerMenu;

        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE.comp_2243();
    }
}
