package net.mehvahdjukaar.moonlight.core.network.fabric;

import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import java.util.Objects;
import java.util.UUID;

public class ClientBoundSpawnCustomEntityMessage implements Message {

    public static final class_9155<class_9129, ClientBoundSpawnCustomEntityMessage> TYPE = Message.makeType(
            Moonlight.res("s2c_spawn_entity"), ClientBoundSpawnCustomEntityMessage::new);

    private final class_1297 entity;
    private final int typeId;
    private final int entityId;
    private final UUID uuid;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final byte pitch;
    private final byte yaw;
    private final byte headYaw;
    private final int velX;
    private final int velY;
    private final int velZ;
    private final class_9129 extraBuf;

    public ClientBoundSpawnCustomEntityMessage(class_1297 e) {
        this.entity = e;
        this.typeId = class_7923.field_41177.method_10206(e.method_5864());
        this.entityId = e.method_5628();
        this.uuid = e.method_5667();
        this.posX = e.method_23317();
        this.posY = e.method_23318();
        this.posZ = e.method_23321();
        this.pitch = (byte) class_3532.method_15375(e.method_36455() * 256.0F / 360.0F);
        this.yaw = (byte) class_3532.method_15375(e.method_36454() * 256.0F / 360.0F);
        this.headYaw = (byte) ((int) (e.method_5791() * 256.0F / 360.0F));
        class_243 vec3d = e.method_18798();
        double d1 = class_3532.method_15350(vec3d.field_1352, -3.9, 3.9);
        double d2 = class_3532.method_15350(vec3d.field_1351, -3.9, 3.9);
        double d3 = class_3532.method_15350(vec3d.field_1350, -3.9, 3.9);
        this.velX = (int) (d1 * 8000.0);
        this.velY = (int) (d2 * 8000.0);
        this.velZ = (int) (d3 * 8000.0);
        class_5455 ra = PlatHelper.getCurrentServer().method_30611();
        this.extraBuf = new class_9129(Unpooled.buffer(), ra);
        if (this.entity instanceof IExtraClientSpawnData spawnData) {
            spawnData.writeSpawnData(extraBuf);
        }
    }

    public ClientBoundSpawnCustomEntityMessage(class_9129 buf) {
        this.entity = null;
        this.typeId = buf.method_10816();
        this.entityId = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.pitch = buf.readByte();
        this.yaw = buf.readByte();
        this.headYaw = buf.readByte();
        this.velX = buf.readShort();
        this.velY = buf.readShort();
        this.velZ = buf.readShort();
        this.extraBuf = new class_9129(buf.copy(), buf.method_56349());
        buf.method_52931();
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_10804(this.typeId);
        buf.method_53002(this.entityId);
        buf.method_52974(this.uuid.getMostSignificantBits());
        buf.method_52974(this.uuid.getLeastSignificantBits());
        buf.method_52940(this.posX);
        buf.method_52940(this.posY);
        buf.method_52940(this.posZ);
        buf.method_52997(this.pitch);
        buf.method_52997(this.yaw);
        buf.method_52997(this.headYaw);
        buf.method_52998(this.velX);
        buf.method_52998(this.velY);
        buf.method_52998(this.velZ);
        buf.method_52975(this.extraBuf);
    }

    @Override
    public void handle(Context context) {
        class_1299<?> type = class_7923.field_41177.method_10200(this.typeId);

        class_1937 world = context.getPlayer().method_37908();
        class_1297 e = type.method_5883(world);
        if (e != null) {
            e.method_43391(this.posX, this.posY, this.posZ);
            e.method_5641(this.posX, this.posY, this.posZ, (this.yaw * 360) / 256.0F, (this.pitch * 360) / 256.0F);
            e.method_5847((this.headYaw * 360) / 256.0F);
            e.method_5636((this.headYaw * 360) / 256.0F);
            e.method_5838(this.entityId);
            e.method_5826(this.uuid);
            Objects.requireNonNull(class_638.class);

            clientSideStuff(world, e);

            e.method_5750(this.velX / 8000.0, this.velY / 8000.0, this.velZ / 8000.0);
            if (e instanceof IExtraClientSpawnData spawnData) {
                spawnData.readSpawnData(this.extraBuf);
            }
        }
        this.extraBuf.method_52931();
    }

    @Environment(EnvType.CLIENT)
    private void clientSideStuff(class_1937 world, class_1297 e) {
        ((class_638) world).method_53875(e);
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE.comp_2243();
    }
}
