package net.mehvahdjukaar.moonlight.core.pack;

import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1011;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

public class MergedDynamicClientResourcesProvider implements class_3262, SimplePackProvider {

    private final Set<DynamicResourcesProvider> providers = new HashSet<>();
    private final List<class_3262> packResourcesStack = new ArrayList<>();
    private final class_9224 locationInfo;
    private final Set<String> modNamespaces = new HashSet<>();
    private class_3272 metadata;
    private byte[] packIcon;

    public MergedDynamicClientResourcesProvider(class_9224 info) {
        this.locationInfo = info;
    }

    public void add(DynamicResourcesProvider provider) {
        if (provider.getPackType() != class_3264.field_14188) {
            throw new IllegalArgumentException("Tried to merge a pack provider of type " + provider.getPackType() +
                    " to a merged provider of type " + class_3264.field_14188);
        }
        if (this.providers.add(provider)) {
            this.packResourcesStack.add(provider.getPackResources());
            this.packResourcesStack.sort(Comparator.comparing(class_3262::method_14409));
            this.modNamespaces.add(provider.getName().method_12836());
        }
    }

    public void addLegacy(DynamicResourcePack dynPack) {
        this.packResourcesStack.add(dynPack);
        this.packResourcesStack.sort(Comparator.comparing(class_3262::method_14409));
        this.modNamespaces.add(dynPack.mainNamespace);
    }

    @Override
    public @Nullable class_7367<InputStream> method_14410(String... strings) {
        String fileName = String.join("/", strings);
        if (fileName.equals("pack.png") && packIcon != null) {
            return () -> new ByteArrayInputStream(packIcon);
        }
        for (class_3262 packResources : this.packResourcesStack) {
            class_7367<InputStream> r = packResources.method_14410(strings);
            if (r != null) return r;
        }
        return null;
    }

    @Override
    public @Nullable class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        Iterator<class_3262> iterator = this.packResourcesStack.iterator();

        class_7367<InputStream> ioSupplier;
        do {
            if (!iterator.hasNext()) {
                return null;
            }

            class_3262 packResources = iterator.next();
            ioSupplier = packResources.method_14405(packType, location);
        } while (ioSupplier == null);

        return ioSupplier;
    }

    @Override
    public void method_14408(class_3264 packType, String namespace, String path, class_7664 resourceOutput) {
        Map<class_2960, class_7367<InputStream>> map = new HashMap<>();
        for (class_3262 packResources : this.packResourcesStack) {
            Objects.requireNonNull(map);
            packResources.method_14408(packType, namespace, path, map::putIfAbsent);
        }

        map.forEach(resourceOutput);
    }

    @Override
    public Set<String> method_14406(class_3264 type) {
        Set<String> set = new HashSet<>();
        for (class_3262 packResources : this.packResourcesStack) {
            set.addAll(packResources.method_14406(type));
        }
        return set;
    }

    @Override
    public @Nullable <T> T method_14407(class_3270<T> serializer) throws IOException {
        if (metadata == null) {
            this.metadata = new class_3272(class_2561
                    .method_43469("message.moonlight.merged_pack.description", modNamespaces.size()),
                    class_155.method_16673().method_48017(class_3264.field_14188),
                    Optional.empty());
        }
        return serializer == class_3272.field_14202 ? (T) this.metadata : null;
    }

    @Override
    public class_9224 method_56926() {
        return locationInfo;
    }

    @Override
    public void close() {
        this.packResourcesStack.forEach(class_3262::close);
    }

    public int size() {
        return this.packResourcesStack.size();
    }

    private void checkInitialized() {
        if (this.packIcon == null) {
            this.packIcon = createIcon();
        }
    }

    private byte[] createIcon() {
        List<class_1011> icons = new ArrayList<>();
        for (var p : packResourcesStack) {
            var icon = p.method_14410("pack.png");
            if (icon != null) {
                try (var s = icon.get()) {
                    icons.add(class_1011.method_4309(s));
                } catch (Exception e) {
                    Moonlight.LOGGER.error("Failed to read pack icon from {}", p.method_14409(), e);
                }
            }else{
                Moonlight.LOGGER.warn("Pack {} has no icon", p.method_14409());
            }
        }
        try (class_1011 image = ImageMerger.mergeSquare(icons, ImageMerger.Mode.MIN_AREA_NO_UPSCALE, 0xFF000000)) {
            return image.method_24036();
        } catch (Exception ignored) {
            Moonlight.LOGGER.error("Failed to merge pack icons");
        } finally {
            for (var i : icons) i.close();
        }
        return null;
    }


    @Override
    public class_3288 createPack() {

        class_3262 resources = this;
        return class_3288.method_45275(
                this.locationInfo,
                new class_3288.class_7680() {
                    @Override
                    public class_3262 method_52424(class_9224 location) {
                        checkInitialized();
                        return resources;
                    }

                    @Override
                    public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
                        return resources;
                    }
                },
                class_3264.field_14188,
                new class_9225(
                        true, class_3288.class_3289.field_14280, false
                )
        );
    }
}
