package net.mehvahdjukaar.moonlight.fabric;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.fabric.ClientBoundSyncDataMapsPacket;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_3962;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Function;

// bro totally unneeded lol
public abstract class DataMapBridge<T, O> extends class_4080<List<JsonElement>> {

    public static final Map<String, Function<class_7225.class_7874, DataMapBridge<?, ?>>> FACTORIES = new HashMap<>();
    private static final Map<String, DataMapBridge<?, ?>> SERVER_INSTANCES = new HashMap<>();
    private static final String ML_MARKER = "moonlight_parse_on_fabric";


    @ApiStatus.Internal
    public static void init() {
        register(BurnTimes.FUEL, BurnTimes::new);
        register(Compostables.COMPOSTABLES, Compostables::new);
        register(Oxidisables.OXIDISABLES, Oxidisables::new);
        register(Waxables.WAXABLES, Waxables::new);

        for (var f : FACTORIES.entrySet()) {
            String mapID = f.getKey();
            class_2960 reloadID = Moonlight.res(mapID);
            PlatHelper.addServerReloadListener(r -> {
                DataMapBridge<?, ?> instance = f.getValue().apply(r);
                SERVER_INSTANCES.put(mapID, instance);
                return instance;
            }, reloadID);
        }
    }

    @ApiStatus.Internal
    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        for (var entry : SERVER_INSTANCES.entrySet()) {
            var map = entry.getValue();
            NetworkHelper.sendToClientPlayer(player, new ClientBoundSyncDataMapsPacket(map));
        }
    }

    public static void register(String path, Function<class_7225.class_7874, DataMapBridge<?, ?>> factory) {
        FACTORIES.put(path, factory);
    }


    private static final Gson GSON = new Gson();
    public final String path;
    private final class_7225.class_7874 registryAccess;
    public final Codec<Map<class_6885<O>, T>> mapCodec;
    public final class_9139<class_9129, Map<class_6885<O>, T>> streamCodec;
    public final Map<class_6885<O>, T> map = new HashMap<>();

    protected DataMapBridge(String path, class_7225.class_7874 registryAccess,
                            Codec<T> entryCodec, class_5321<? extends class_2378<O>> reg) {
        this.path = path;
        this.registryAccess = registryAccess;

        //doesn't support replace or any fancy stuff like that
        this.mapCodec = RecordCodecBuilder.create(i -> i.group(
                Codec.unboundedMap(class_6895.method_40340(reg), entryCodec)
                        .fieldOf("values").forGetter(m -> m)
        ).apply(i, HashMap::new));

        this.streamCodec = class_9135.method_56377(i -> new HashMap<>(),
                class_9135.method_58001(reg), class_9135.method_56368(entryCodec));
    }


    @Override
    protected final List<JsonElement> method_18789(class_3300 resourceManager, class_3695 profiler) {
        List<JsonElement> output = new ArrayList<>();
        var m = resourceManager.method_41265(path, r->true);
        var list = new ArrayList<class_3298>();
        for (var res : m.values()) {
            list.addAll(res);
        }
        for (var res : list) {
            try (Reader reader = res.method_43039()) {
                JsonElement jsonElement = class_3518.method_15276(GSON, reader, JsonElement.class);
                output.add(jsonElement);
            } catch (IllegalArgumentException | IOException | JsonParseException var14) {
                Moonlight.LOGGER.error("Couldn't parse data file {} from {}", res, path);
            }
        }
        return output;
    }

    @Override
    protected final void apply(List<JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        this.map.clear();
        var ops = class_6903.method_46632(JsonOps.INSTANCE, registryAccess);
        for (var entry : jsons) {
            if (entry instanceof JsonObject jo && jo.has(ML_MARKER)) {
                var parsed = this.mapCodec.parse(ops, jo).getOrThrow();
                this.map.putAll(parsed);
            }
        }
        applyData();
    }

    public final void applyData() {
        for (var entry : this.map.entrySet()) {
            for (var holder : entry.getKey()) {
                var object = holder.comp_349();
                var data = entry.getValue();
                this.applyEntry(object, data);
            }
        }
    }

    protected abstract void applyEntry(O object, T dataEntry);

    public void encode(class_9129 buf) {
        streamCodec.encode(buf, this.map);
    }

    public void decode(class_9129 buf) {
        this.map.clear();
        this.map.putAll(streamCodec.decode(buf));
    }


    protected static class BurnTimes extends DataMapBridge<BurnTimes.FurnaceFuel, class_1792> {
        protected static final String FUEL = "data_maps/item/furnace_fuels.json";

        protected BurnTimes(class_7225.class_7874 registryAccess) {
            super(FUEL, registryAccess, FurnaceFuel.CODEC, class_7924.field_41197);
        }

        @Override
        protected void applyEntry(class_1792 object, FurnaceFuel dataEntry) {
            FuelRegistry.INSTANCE.add(object, dataEntry.burnTime);
        }

        protected record FurnaceFuel(int burnTime) {
            public static final Codec<FurnaceFuel> CODEC = Codec.withAlternative(
                    RecordCodecBuilder.create(in -> in.group(
                            class_5699.field_33442.fieldOf("burn_time").forGetter(FurnaceFuel::burnTime)).apply(in, FurnaceFuel::new)),
                    class_5699.field_33442.xmap(FurnaceFuel::new, FurnaceFuel::burnTime));
        }
    }

    protected static class Compostables extends DataMapBridge<Compostables.Compostable, class_1792> {
        protected static final String COMPOSTABLES = "data_maps/item/compostables.json";

        protected Compostables(class_7225.class_7874 registryAccess) {
            super(COMPOSTABLES, registryAccess, Compostable.CODEC, class_7924.field_41197);
        }

        @Override
        protected void applyEntry(class_1792 object, Compostable dataEntry) {
            class_3962.field_17566.put(object, dataEntry.chance);
        }

        protected record Compostable(float chance, boolean canVillagerCompost) {
            public static final Codec<Compostable> CODEC = Codec.withAlternative(
                    RecordCodecBuilder.create(in -> in.group(
                            Codec.floatRange(0f, 1f).fieldOf("chance").forGetter(Compostable::chance),
                            Codec.BOOL.optionalFieldOf("can_villager_compost", false).forGetter(Compostable::canVillagerCompost)).apply(in, Compostable::new)),
                    Codec.floatRange(0f, 1f).xmap(Compostable::new, Compostable::chance));

            public Compostable(float chance) {
                this(chance, false);
            }
        }

    }

    protected static class Oxidisables extends DataMapBridge<Oxidisables.Oxidizable, class_2248> {
        protected static final String OXIDISABLES = "data_maps/block/oxidizables.json";

        protected Oxidisables(class_7225.class_7874 registryAccess) {
            super(OXIDISABLES, registryAccess, Oxidizable.CODEC, class_7924.field_41254);
        }

        @Override
        protected void applyEntry(class_2248 object, Oxidizable dataEntry) {
            OxidizableBlocksRegistry.registerOxidizableBlockPair(object, dataEntry.nextOxidationStage);
        }

        public record Oxidizable(class_2248 nextOxidationStage) {
            public static final Codec<Oxidizable> CODEC = Codec.withAlternative(
                    RecordCodecBuilder.create(in -> in.group(
                            class_7923.field_41175.method_39673().fieldOf("next_oxidation_stage").forGetter(Oxidizable::nextOxidationStage)).apply(in, Oxidizable::new)),
                    class_7923.field_41175.method_39673()
                            .xmap(Oxidizable::new, Oxidizable::nextOxidationStage));
        }

    }

    protected static class Waxables extends DataMapBridge<Waxables.Waxable, class_2248> {
        protected static final String WAXABLES = "data_maps/block/waxables.json";

        protected Waxables(class_7225.class_7874 registryAccess) {
            super(WAXABLES, registryAccess, Waxable.CODEC, class_7924.field_41254);
        }

        @Override
        protected void applyEntry(class_2248 object, Waxable dataEntry) {
            OxidizableBlocksRegistry.registerWaxableBlockPair(object, dataEntry.waxed);
        }

        public record Waxable(class_2248 waxed) {
            public static final Codec<Waxable> CODEC = Codec.withAlternative(
                    RecordCodecBuilder.create(in -> in.group(
                            class_7923.field_41175.method_39673().fieldOf("waxed").forGetter(Waxable::waxed)).apply(in, Waxable::new)),
                    class_7923.field_41175.method_39673()
                            .xmap(Waxable::new, Waxable::waxed));
        }
    }


}
