package net.mehvahdjukaar.moonlight.api.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import java.util.stream.IntStream;

public abstract class ItemDisplayTile extends RandomizableContainerBlockEntity implements WorldlyContainer, IOwnerProtected {
    @Nullable
    private UUID owner = null;
    private NonNullList<ItemStack> stacks;

    protected ItemDisplayTile(BlockEntityType type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    protected ItemDisplayTile(BlockEntityType type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state);
        this.stacks = NonNullList.m_122780_(slots, ItemStack.f_41583_);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return owner;
    }

    //should only be server side. called when inventory has changed
    @Override
    public void m_6596_() {
        if (this.f_58857_ == null || f_58857_.f_46443_) return;
        this.updateTileOnInventoryChanged();
        if (this.needsToUpdateClientWhenChanged()) {
            //this saves and sends a packet to update the client tile
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), Block.f_152394_);
        }
        super.m_6596_();
    }

    /**
     * called every time the tile is marked dirty or loaded. Server side method.
     * Put here common logic for things that needs to react to inventory changes like updating blockState or logic
     */
    public void updateTileOnInventoryChanged() {
    }

    /**
     * @return true if the tile needs to react one inventory changes on client.
     * Set to true if you are using updateClientVisualsOnLoad()
     * usually not needed for tiles that do not visually display their content
     */
    public boolean needsToUpdateClientWhenChanged() {
        return true;
    }

    /**
     * Called after the tile is loaded from packet. Client side.
     * Put here client only visual logic that needs to react to inventory changes
     */
    public void updateClientVisualsOnLoad() {
    }

    public ItemStack getDisplayedItem() {
        return this.m_8020_(0);
    }

    public void setDisplayedItem(ItemStack stack) {
        this.m_6836_(0, stack);
    }

    public InteractionResult interact(Player player, InteractionHand handIn) {
        return this.interact(player, handIn, 0);
    }

    public InteractionResult interact(Player player, InteractionHand handIn, int slot) {
        if (!this.isAccessibleBy(player)) {
            player.m_5661_(Component.m_237110_("container.isLocked", ""), true);
        } else if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack handItem = player.m_21120_(handIn);
            //remove
            if (handItem.m_41619_()) {
                ItemStack it = this.m_8016_(slot);
                if (!it.m_41619_()) {
                    onItemRemoved(player, it, slot);
                    if (!this.f_58857_.m_5776_()) {
                        player.m_21008_(handIn, it);
                        this.m_6596_();
                    } else {
                        //also update visuals on client. will get overwritten by packet tho
                        this.updateClientVisualsOnLoad();
                    }
                    return InteractionResult.m_19078_(this.f_58857_.f_46443_);
                }
            }
            //place
            else if (!handItem.m_41619_() && this.m_7013_(slot, handItem)) {
                ItemStack it = handItem.m_41777_();
                it.m_41764_(1);
                this.m_6836_(slot, it);

                if (!player.m_7500_()) {
                    handItem.m_41774_(1);
                }
                onItemAdded(player, it, slot);
                if (!this.f_58857_.m_5776_()) {
                    this.f_58857_.m_5594_(null, this.f_58858_, this.getAddItemSound(), SoundSource.BLOCKS, 1.0F, this.f_58857_.f_46441_.m_188501_() * 0.10F + 0.95F);
                    //this.setChanged();
                } else {
                    //also update visuals on client. will get overwritten by packet tho
                    this.updateClientVisualsOnLoad();
                }
                return InteractionResult.m_19078_(this.f_58857_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void onItemRemoved(Player player, ItemStack stack, int slot) {
        f_58857_.m_220407_(GameEvent.f_157792_, f_58858_, GameEvent.Context.m_223719_(player, m_58900_()));
    }

    public void onItemAdded(Player player, ItemStack stack, int slot) {
        f_58857_.m_220407_(GameEvent.f_157792_, f_58858_, GameEvent.Context.m_223719_(player, m_58900_()));

        //server
        if (player instanceof ServerPlayer serverPlayer) {
            CriteriaTriggers.f_10562_.m_285767_(serverPlayer, f_58858_, stack);
            player.m_36246_(Stats.f_12982_.m_12902_(stack.m_41720_()));
        }
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.f_12013_;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!this.m_59631_(compound)) {
            this.stacks = NonNullList.m_122780_(this.m_6643_(), ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_(compound, this.stacks);
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) this.updateClientVisualsOnLoad();
                //this doesn't work on first load cause world is null on server. You need to save stuff on nbt
            else this.updateTileOnInventoryChanged();
        }
        this.loadOwner(compound);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_(compound, this.stacks);
        }
        this.saveOwner(compound);
    }

    @Override
    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_(this);
    }

    @Override
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public int m_6643_() {
        return stacks.size();
    }

    @Override
    public int m_6893_() {
        return 1;
    }

    //use the one below
    @Deprecated(forRemoval = true)
    @ApiStatus.Internal
    @Override
    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return ChestMenu.m_39237_(id, player, this);
    }

    @Nullable
    @Override
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return null;
    }


    @Override
    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    @Override
    public void m_6520_(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        return this.m_7983_();
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }


}