package net.mehvahdjukaar.moonlight.api.block;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;

import java.lang.reflect.Field;
import java.util.function.Supplier;

public class ModStairBlock extends StairBlock {

    private static final Field FORGE_BLOCK_SUPPLIER = PlatHelper.findField(StairBlock.class, "stateSupplier");

    public ModStairBlock(Supplier<Block> baseBlock, Properties settings) {
        super(FORGE_BLOCK_SUPPLIER == null ? Preconditions.checkNotNull(baseBlock.get(), "Stairs block was given a null base block!")
                .m_49966_() : Blocks.f_50016_.m_49966_(), settings);
        if (FORGE_BLOCK_SUPPLIER != null) {
            FORGE_BLOCK_SUPPLIER.setAccessible(true);
            try {
                FORGE_BLOCK_SUPPLIER.set(this, (Supplier<BlockState>) () -> baseBlock.get().m_49966_());
            } catch (Exception ignored) {
            }
        }
    }
}
