package net.mehvahdjukaar.moonlight.api.client.model.forge;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.Arrays;
import java.util.function.Consumer;

public class BakedQuadBuilderImpl implements BakedQuadBuilder {

    public static BakedQuadBuilder create(TextureAtlasSprite sprite, @Nullable Matrix4f transformation) {
        return new BakedQuadBuilderImpl(sprite, transformation);
    }

    private final QuadBakingVertexConsumer inner;
    private final TextureAtlasSprite sprite;

    private final Matrix4f globalTransform;
    private final Matrix3f normalTransf;

    private int emissivity = 0;
    private BakedQuad output;
    private boolean autoDirection = false;
    private Consumer<BakedQuad> quadConsumer = s -> output = s;


    private BakedQuadBuilderImpl(TextureAtlasSprite sprite, @Nullable Matrix4f transformation) {
        this.inner = new QuadBakingVertexConsumer(s -> quadConsumer.accept(s));
        this.globalTransform = transformation;// == null ? null : new Matrix4f(new Matrix3f(transformation)); //gets rid of translation
        this.sprite = sprite;
        inner.setShade(true);
        inner.setHasAmbientOcclusion(true);
        inner.setSprite(sprite);
        this.normalTransf = transformation == null ? null :
                new Matrix3f(transformation).invert().transpose();
    }

    @Override
    public BakedQuad build() {
        Preconditions.checkNotNull(output, "vertex data has not been fully filled");
        if (emissivity != 0) {
            QuadTransformers.settingEmissivity(emissivity).processInPlace(output);
        }
        return output;
    }

    @Override
    public BakedQuadBuilderImpl setAutoBuild(Consumer<BakedQuad> quadConsumer) {
        this.quadConsumer = quadConsumer;
        return this;
    }


    @Override
    public BakedQuadBuilderImpl m_5483_(double x, double y, double z) {
        if (globalTransform != null) {
            inner.m_252986_(new Matrix4f(globalTransform), (float) x, (float) y, (float) z);
        } else {
            inner.m_5483_(x, y, z);
        }
        return this;
    }

    @Override
    public BakedQuadBuilderImpl m_6122_(int red, int green, int blue, int alpha) {
        inner.m_6122_(red, green, blue, alpha);
        return this;
    }

    //given in sprite coords
    @Override
    public BakedQuadBuilderImpl m_7421_(float u, float v) {
        inner.m_7421_(sprite.m_118367_(u * 16), sprite.m_118393_(v * 16));
        return this;
    }

    @Override
    public BakedQuadBuilderImpl m_7122_(int u, int v) {
        inner.m_7122_(u, v);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl m_7120_(int u, int v) {
        inner.m_7120_(u, v);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl m_5601_(float x, float y, float z) {
        if (globalTransform != null) {
            Vector3f normal = normalTransf.transform(new Vector3f(x, y, z));
            normal.normalize();
            inner.m_5601_(normal.x, normal.y, normal.z);
        } else inner.m_5601_(x, y, z);
        if (autoDirection) {
            this.setDirection(Direction.m_122372_(x, y, z));
        }
        return this;
    }

    @Override
    public void m_5752_() {
        inner.m_5752_();
    }

    @Override
    public void m_7404_(int defaultR, int defaultG, int defaultB, int defaultA) {
        inner.m_7404_(defaultR, defaultG, defaultB, defaultA);
    }

    @Override
    public void m_141991_() {
        inner.m_141991_();
    }


    @Override
    public BakedQuadBuilder setDirection(Direction direction) {
        if (globalTransform != null) {
            direction = Direction.m_252919_(globalTransform, direction);
        }
        this.inner.setDirection(direction);
        return this;
    }

    @Override
    public BakedQuadBuilder setAmbientOcclusion(boolean ambientOcclusion) {
        this.inner.setHasAmbientOcclusion(ambientOcclusion);
        return this;
    }

    @Override
    public BakedQuadBuilder setTint(int tintIndex) {
        inner.setTintIndex(tintIndex);
        return this;
    }

    @Override
    public BakedQuadBuilder setShade(boolean shade) {
        this.inner.setShade(shade);
        return this;
    }

    @Override
    public BakedQuadBuilder lightEmission(int light) {
        this.emissivity = light;
        return this;
    }

    @Override
    public BakedQuadBuilder fromVanilla(BakedQuad q) {
        int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
        output = new BakedQuad(v, q.m_111305_(), q.m_111306_(), q.m_173410_(), q.m_111307_(), q.hasAmbientOcclusion());
        return this;
    }

    @Override
    public BakedQuadBuilder setAutoDirection() {
        this.autoDirection = true;
        return this;
    }
}
