package net.mehvahdjukaar.moonlight.api.client.util;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class LOD {
    public static final LOD MAX = new LOD(0);

    private final double distSq;

    private LOD(double distance) {
        this.distSq = distance;
    }

    public LOD(Camera camera, BlockPos pos) {
        this(camera.m_90583_(), pos);
    }

    public LOD(Vec3 cameraPos, BlockPos pos) {
        this(isScoping() ? 1 : Vec3.m_82512_(pos).m_82557_(cameraPos));
    }

    public static boolean isScoping(){
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        return localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_();
    }

    public boolean isVeryNear() {
        return this.distSq < VERY_NEAR_DIST;
    }

    public boolean isNear() {
        return this.distSq < NEAR_DIST;
    }

    public boolean isNearMed() {
        return this.distSq < NEAR_MED_DIST;
    }

    public boolean isMedium() {
        return this.distSq < MEDIUM_DIST;
    }

    public boolean isFar() {
        return this.distSq < FAR_DIST;
    }


    //all squared
    public static final int BUFFER = 2 * 2;
    public static final int VERY_NEAR_DIST = 16 * 16;
    public static final int NEAR_DIST = 32 * 32;
    public static final int NEAR_MED_DIST = 48 * 48;
    public static final int MEDIUM_DIST = 64 * 64;
    public static final int FAR_DIST = 96 * 96;

    //TODO: refactor and make member methods
    @Deprecated(forRemoval = true)
    public static boolean isOutOfFocus(Vec3 cameraPos, BlockPos pos, float blockYaw) {
        return isOutOfFocus(cameraPos, pos, blockYaw, 0, Direction.UP, 0);
    }

    @Deprecated(forRemoval = true)
    public static boolean isOutOfFocus(Vec3 cameraPos, BlockPos pos, float blockYaw, float degMargin, Direction dir, float offset) {
        float relAngle = getRelativeAngle(cameraPos, pos, dir, offset);
        return isOutOfFocus(relAngle, blockYaw, degMargin);
    }

    @Deprecated(forRemoval = true)
    public static boolean isOutOfFocus(float relativeAngle, float blockYaw, float degMargin) {
        return (Mth.m_14118_(relativeAngle, blockYaw - 90) > -degMargin);
    }

    public static float getRelativeAngle(Vec3 cameraPos, BlockPos pos) {
        return getRelativeAngle(cameraPos, pos, Direction.UP, 0);
    }

    public static float getRelativeAngle(Vec3 cameraPos, BlockPos pos, Direction dir, float offset) {
        return (float) (Mth.m_14136_(
                offset * dir.m_122429_() + cameraPos.f_82479_ - (pos.m_123341_() + 0.5f),
                offset * dir.m_122431_() + cameraPos.f_82481_ - (pos.m_123343_() + 0.5f)) * 180 / Math.PI);
    }

}
