package net.mehvahdjukaar.moonlight.api.client.util;

import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

import java.util.function.Supplier;

public class ParticleUtil {

    public static void spawnParticleInASphere(Level level, double x, double y, double z, Supplier<ParticleOptions> type,
                                              int amount, float speed,
                                              float angleVariation, float speedVariation) {
        double azimuthIncrement = Math.PI * (3 - Math.sqrt(5)); // Golden angle

        for (int i = 0; i < amount; i++) {
            double inclination = Math.acos(1 - (2 * (i + 0.5) / amount)); // Angle from the pole
            double azimuth = azimuthIncrement * i; // Rotation around the axis

            if (angleVariation != 0) {
                inclination += level.f_46441_.m_188501_() * angleVariation - angleVariation / 2;
                azimuth += level.f_46441_.m_188501_() * angleVariation - angleVariation / 2;
            }

            float s = speed;
            if (speedVariation != 0) {
                s += level.f_46441_.m_188501_() * speedVariation - speedVariation / 2;
            }

            double vx = s * Math.sin(inclination) * Math.cos(azimuth);
            double vy = s * Math.sin(inclination) * Math.sin(azimuth);
            double vz = s * Math.cos(inclination);

            level.m_7106_(type.get(), x, y, z, vx, vy, vz);
        }
    }

    //call with packet

    public static void spawnParticleOnBlockShape(Level level, BlockPos pos, ParticleOptions particleOptions,
                                                 UniformInt uniformInt, float maxSpeed) {
        spawnParticleOnBoundingBox(level.m_8055_(pos).m_60808_(level, pos).m_83215_().m_82338_(pos), level,
                particleOptions, uniformInt, maxSpeed);
    }

    public static void spawnParticleOnBoundingBox(AABB bb, Level level, ParticleOptions particleOptions,
                                                  UniformInt uniformInt, float maxSpeed) {

        RandomSource random = level.f_46441_;
        float offset = 0.1f;
        Vec3 blockCenter = new Vec3(bb.f_82288_ - 0.5 + (bb.f_82291_ - bb.f_82288_) / 2f, bb.f_82289_ - 0.5 + (bb.f_82292_ - bb.f_82289_) / 2f, bb.f_82290_ - 0.5 + (bb.f_82293_ - bb.f_82290_) / 2f);
        bb = bb.m_82386_(-blockCenter.f_82479_, -blockCenter.f_82480_, -blockCenter.f_82481_);
        //north
        int i = uniformInt.m_214085_(random);
        for (int j = 0; j < i; ++j) {
            double x = random.m_188500_();
            double y = random.m_188500_();
            if (x > bb.f_82288_ && x < bb.f_82291_ && y > bb.f_82289_ && y < bb.f_82292_) {
                double dx = maxSpeed * level.f_46441_.m_188500_();
                double dy = maxSpeed * level.f_46441_.m_188500_();
                double dz = 0;
                level.m_7106_(particleOptions, blockCenter.f_82479_ + x, blockCenter.f_82480_ + y, blockCenter.f_82481_ + bb.f_82290_ - offset, dx, dy, dz);
            }
        }
        //south
        i = uniformInt.m_214085_(random);
        for (int j = 0; j < i; ++j) {
            double x = random.m_188500_();
            double y = random.m_188500_();
            if (x > bb.f_82288_ && x < bb.f_82291_ && y > bb.f_82289_ && y < bb.f_82292_) {
                double dx = maxSpeed * level.f_46441_.m_188500_();
                double dy = maxSpeed * level.f_46441_.m_188500_();
                double dz = 0;
                level.m_7106_(particleOptions, blockCenter.m_7096_() + x, blockCenter.m_7098_() + y, blockCenter.m_7094_() + bb.f_82293_ + offset, dx, dy, dz);
            }
        }
        //west
        i = uniformInt.m_214085_(random);
        for (int j = 0; j < i; ++j) {
            double z = random.m_188500_();
            double y = random.m_188500_();
            if (z > bb.f_82290_ && z < bb.f_82293_ && y > bb.f_82289_ && y < bb.f_82292_) {
                double dx = 0;
                double dy = maxSpeed * level.f_46441_.m_188500_();
                double dz = maxSpeed * level.f_46441_.m_188500_();
                level.m_7106_(particleOptions, blockCenter.m_7096_() + bb.f_82288_ - offset, blockCenter.m_7098_() + y, blockCenter.m_7094_() + z, dx, dy, dz);
            }
        }
        //east
        i = uniformInt.m_214085_(random);
        for (int j = 0; j < i; ++j) {
            double z = random.m_188500_();
            double y = random.m_188500_();
            if (z > bb.f_82290_ && z < bb.f_82293_ && y > bb.f_82289_ && y < bb.f_82292_) {
                double dx = 0;
                double dy = maxSpeed * level.f_46441_.m_188500_();
                double dz = maxSpeed * level.f_46441_.m_188500_();
                level.m_7106_(particleOptions, blockCenter.m_7096_() + bb.f_82291_ + offset, blockCenter.m_7098_() + y, blockCenter.m_7094_() + z, dx, dy, dz);
            }
        }
        //down
        i = uniformInt.m_214085_(random);
        for (int j = 0; j < i; ++j) {
            double x = random.m_188500_();
            double z = random.m_188500_();
            if (x > bb.f_82288_ && x < bb.f_82291_ && z > bb.f_82290_ && z < bb.f_82293_) {
                double dx = maxSpeed * level.f_46441_.m_188500_();
                double dy = 0;
                double dz = maxSpeed * level.f_46441_.m_188500_();
                level.m_7106_(particleOptions, blockCenter.m_7096_() + x, blockCenter.m_7098_() + bb.f_82289_ - offset, blockCenter.m_7094_() + z, dx, dy, dz);
            }
        }
        //up
        i = uniformInt.m_214085_(random);
        for (int j = 0; j < i; ++j) {
            double x = random.m_188500_();
            double z = random.m_188500_();
            if (x > bb.f_82288_ && x < bb.f_82291_ && z > bb.f_82290_ && z < bb.f_82293_) {
                double dx = maxSpeed * level.f_46441_.m_188500_();
                double dy = 0;
                double dz = maxSpeed * level.f_46441_.m_188500_();
                level.m_7106_(particleOptions, blockCenter.m_7096_() + x, blockCenter.m_7098_() + bb.f_82292_ + offset, blockCenter.m_7094_() + z, dx, dy, dz);
            }
        }
    }


    public static void spawnParticlesOnBlockFaces(Level level, BlockPos pos, ParticleOptions particleOptions,
                                                  UniformInt uniformInt, float minSpeed, float maxSpeed, boolean perpendicular) {
        for (Direction direction : Direction.values()) {
            int i = uniformInt.m_214085_(level.f_46441_);

            for (int j = 0; j < i; ++j) {
                spawnParticleOnFace(level, pos, direction, particleOptions, minSpeed, maxSpeed, perpendicular);
            }
        }
    }

    public static void spawnParticleOnFace(Level level, BlockPos pos, Direction direction, ParticleOptions particleOptions,
                                           float minSpeed, float maxSpeed, boolean perpendicular) {
        Vec3 vec3 = Vec3.m_82512_(pos);
        int i = direction.m_122429_();
        int j = direction.m_122430_();
        int k = direction.m_122431_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_216263_(level.f_46441_, -0.5D, 0.5D) : i * 0.6D);
        double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_216263_(level.f_46441_, -0.5D, 0.5D) : j * 0.6D);
        double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_216263_(level.f_46441_, -0.5D, 0.5D) : k * 0.6D);
        double dx;
        double dy;
        double dz;
        if (perpendicular) {
            dx = i * Mth.m_216283_(level.f_46441_, minSpeed, maxSpeed);
            dy = j * Mth.m_216283_(level.f_46441_, minSpeed, maxSpeed);
            dz = k * Mth.m_216283_(level.f_46441_, minSpeed, maxSpeed);
        } else {
            float d = maxSpeed - minSpeed;

            dx = (i == 0) ? (minSpeed + d * level.f_46441_.m_188500_()) : 0.0D;
            dy = (j == 0) ? (minSpeed + d * level.f_46441_.m_188500_()) : 0.0D;
            dz = (k == 0) ? (minSpeed + d * level.f_46441_.m_188500_()) : 0.0D;
        }
        level.m_7106_(particleOptions, d0, d1, d2, dx, dy, dz);
    }


    public static void spawnBreakParticles(VoxelShape shape, BlockPos pPos, BlockState pState, Level level) {

        var particleEngine = Minecraft.m_91087_().f_91061_;

        shape.m_83286_((x0, y0, z0, x1, y1, z1) -> {
            double d1 = Math.min(1.0D, x1 - x0);
            double d2 = Math.min(1.0D, y1 - y0);
            double d3 = Math.min(1.0D, z1 - z0);
            int i = Math.max(2, Mth.m_14165_(d1 / 0.25D));
            int j = Math.max(2, Mth.m_14165_(d2 / 0.25D));
            int k = Math.max(2, Mth.m_14165_(d3 / 0.25D));

            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = (l + 0.5D) / i;
                        double d5 = (i1 + 0.5D) / j;
                        double d6 = (j1 + 0.5D) / k;
                        double d7 = d4 * d1 + x0;
                        double d8 = d5 * d2 + y0;
                        double d9 = d6 * d3 + z0;
                        particleEngine.m_107344_(new TerrainParticle((ClientLevel) level, pPos.m_123341_() + d7, pPos.m_123342_() + d8,
                                pPos.m_123343_() + d9, d4 - 0.5D, d5 - 0.5D, d6 - 0.5D, pState, pPos));
                    }
                }
            }
        });
    }

    @Deprecated(forRemoval = true)
    public static final ParticleRenderType ADDITIVE_TRANSLUCENCY_RENDER_TYPE = MLRenderTypes.PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE;
}
