package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

import java.util.function.BiConsumer;


public class RenderUtil {

    static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.m_245263_("trident", "inventory");
    static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.m_245263_("spyglass", "inventory");


    @ExpectPlatform
    public static void renderBlock(BakedModel model, long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state,
                                   Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        throw new AssertionError();
    }

    public static void renderBlock(long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state,
                                   Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        BakedModel model = dispatcher.m_110910_(state);
        renderBlock(model, seed, poseStack, buffer, state, level, pos, dispatcher);
    }

    @Deprecated(forRemoval = true)
    public static void renderBlockModel(ResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer,
                                        BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        renderModel(modelLocation, matrixStack, buffer, blockRenderer, light, overlay, cutout);
    }

    //should be a weaker version of what's above as it doesnt take in level so stuff like offset isnt there
    //from resource location
    public static void renderModel(ResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer,
                                   BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {

        blockRenderer.m_110937_().m_111067_(matrixStack.m_85850_(),
                buffer.m_6299_(cutout ? Sheets.m_110790_() : Sheets.m_110789_()),
                null,
                ClientHelper.getModel(blockRenderer.m_110907_().m_110881_(), modelLocation),
                1.0F, 1.0F, 1.0F,
                light, overlay);
    }

    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer,
                                             BiConsumer<PoseStack, BakedModel> movement) {
        renderGuiItemRelative(poseStack, stack, x, y, renderer, movement, LightTexture.f_173040_, OverlayTexture.f_118083_);
    }


    //im not even using this on fabric...
    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer,
                                             BiConsumer<PoseStack, BakedModel> movement, int combinedLight, int pCombinedOverlay) {

        BakedModel model = renderer.m_174264_(stack, null, null, 0);
        int l = 0;

        poseStack.m_85836_();

        poseStack.m_252880_((x + 8), (y + 8), (150 + (model.m_7539_() ? l : 0)));
        poseStack.m_252931_((new Matrix4f()).scaling(1.0F, -1.0F, 1.0F));
        poseStack.m_85841_(16.0F, 16.0F, 16.0F);

        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        } else {
            Lighting.m_84931_();
        }

        //-----render---
        ItemDisplayContext pTransformType = ItemDisplayContext.GUI;

        // applies rotation first then custom rot and gives display context of none
        model = handleCameraTransforms(model, poseStack, pTransformType);

        //custom rotation

        movement.accept(poseStack, model);

        renderer.m_115143_(stack, ItemDisplayContext.NONE, false, poseStack, bufferSource,
                combinedLight, pCombinedOverlay, model);

        //----end-render---

        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
    }

    @ExpectPlatform
    private static BakedModel handleCameraTransforms(BakedModel model, PoseStack matrixStack, ItemDisplayContext pTransformType) {
        throw new ArrayStoreException();
    }

    @Deprecated(forRemoval = true)
    @ExpectPlatform
    public static void renderGuiItem(BakedModel model, ItemStack stack, ItemRenderer renderer, int combinedLight, int pCombinedOverlay,
                                     PoseStack poseStack, MultiBufferSource.BufferSource buffer, boolean flatItem) {
        throw new ArrayStoreException();
    }

    public static GuiGraphics getGuiDummy(PoseStack poseStack) {
        var mc = Minecraft.m_91087_();
        return new GuiGraphics(mc, poseStack, mc.m_91269_().m_110104_());
    }

    /**
     * Renders the given sprite or sprite section. Meant for GUI
     *
     * @param x      x position
     * @param y      y position
     * @param w      width
     * @param h      height
     * @param u      sprite local u
     * @param v      sprite local v
     * @param uW     sprite section width
     * @param vH     sprite section height
     * @param sprite can be grabbed from a material
     */
    public static void blitSpriteSection(GuiGraphics graphics, int x, int y, int w, int h,
                                         float u, float v, int uW, int vH, TextureAtlasSprite sprite) {
        var c = sprite.m_245424_();
        int width = (int) (c.m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
        int height = (int) (c.m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
        graphics.m_280411_(sprite.m_247685_(), x, y, w, h, sprite.m_118367_(u) * width, height * sprite.m_118393_(v), uW, vH, width, height);
    }

    public static void renderSprite(PoseStack stack, VertexConsumer vertexBuilder, int light, int index,
                                    int b, int g, int r, TextureAtlasSprite sprite) {
        renderSprite(stack, vertexBuilder, light, index, b, g, r, 255, sprite);
    }

    public static void renderSprite(PoseStack stack, VertexConsumer vertexBuilder, int light, int index,
                                    int b, int g, int r, int a, TextureAtlasSprite sprite) {
        Matrix4f matrix4f1 = stack.m_85850_().m_252922_();
        float u0 = sprite.m_118367_(0);
        float u1 = sprite.m_118367_(16);
        float h = (u0 + u1) / 2.0f;
        float v0 = sprite.m_118393_(0);
        float v1 = sprite.m_118393_(16);
        float k = (v0 + v1) / 2.0f;
        float shrink = sprite.m_118417_();
        float u0s = Mth.m_14179_(shrink, u0, h);
        float u1s = Mth.m_14179_(shrink, u1, h);
        float v0s = Mth.m_14179_(shrink, v0, k);
        float v1s = Mth.m_14179_(shrink, v1, k);

        vertexBuilder.m_252986_(matrix4f1, -1.0F, 1.0F, index * -0.001F).m_6122_(r, g, b, a).m_7421_(u0s, v1s).m_85969_(light).m_5752_();
        vertexBuilder.m_252986_(matrix4f1, 1.0F, 1.0F, index * -0.001F).m_6122_(r, g, b, a).m_7421_(u1s, v1s).m_85969_(light).m_5752_();
        vertexBuilder.m_252986_(matrix4f1, 1.0F, -1.0F, index * -0.001F).m_6122_(r, g, b, a).m_7421_(u1s, v0s).m_85969_(light).m_5752_();
        vertexBuilder.m_252986_(matrix4f1, -1.0F, -1.0F, index * -0.001F).m_6122_(r, g, b, a).m_7421_(u0s, v0s).m_85969_(light).m_5752_();
    }


    /**
     * Text render type that can use mipmap.
     */
    public static RenderType getTextMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.TEXT_MIP.apply(texture);
    }

    public static RenderType getEntityCutoutMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.ENTITY_CUTOUT_MIP.apply(texture);
    }

    public static RenderType getEntitySolidMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.ENTITY_SOLID_MIP.apply(texture);
    }

    public static RenderType getTextColorRenderType(ResourceLocation texture) {
        return MLRenderTypes.COLOR_TEXT.apply(texture);
    }

    /**
     * Call at appropriate times to turn your dynamic textures into mipmapped ones. Remember to turn off
     */
    public static void setDynamicTexturesToUseMipmap(boolean mipMap) {
        MoonlightClient.setMipMap(mipMap);
    }


}

