package net.mehvahdjukaar.moonlight.api.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.phys.Vec3;

public class ImprovedFallingBlockEntity extends FallingBlockEntity {

    protected boolean saveTileDataToItem;

    public ImprovedFallingBlockEntity(EntityType<? extends FallingBlockEntity> type, Level level) {
        super(type, level);
        saveTileDataToItem = false;
    }

    public ImprovedFallingBlockEntity(EntityType<? extends FallingBlockEntity> type, Level level, BlockPos pos,
                                      BlockState blockState, boolean saveDataToItem) {
        super(type, level);
        this.f_19850_ = true;
        this.f_19854_ = pos.m_123341_() + 0.5D;
        this.f_19855_ = pos.m_123342_();
        this.f_19856_ = pos.m_123343_() + 0.5D;
        this.m_6034_(f_19854_, f_19855_ + ((1.0F - this.m_20206_()) / 2.0F), f_19856_);
        this.m_20256_(Vec3.f_82478_);
        this.m_31959_(this.m_20183_());
        this.setBlockState(blockState);
        this.saveTileDataToItem = saveDataToItem;
    }

    public static ImprovedFallingBlockEntity fall(EntityType<? extends FallingBlockEntity> type, Level level,
                                                  BlockPos pos, BlockState state, boolean saveDataToItem) {
        ImprovedFallingBlockEntity entity = new ImprovedFallingBlockEntity(type, level, pos, state,
                saveDataToItem);
        level.m_7731_(pos, state.m_60819_().m_76188_(), 3);
        level.m_7967_(entity);
        return entity;
    }

    public void setSaveTileDataToItem(boolean b) {
        this.saveTileDataToItem = b;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("saveToItem", this.saveTileDataToItem);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.saveTileDataToItem = tag.m_128471_("saveToItem");
    }

    //workaround
    public void setBlockState(BlockState state) {
        if (state.m_61138_(BlockStateProperties.f_61362_)) {
            state = state.m_61124_(BlockStateProperties.f_61362_, false);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("BlockState", NbtUtils.m_129202_(state));
        tag.m_128405_("Time", this.f_31942_);
        this.m_7378_(tag);
    }

    @Override
    public ItemEntity m_20000_(ItemLike itemIn, int offset) {
        ItemStack stack = new ItemStack(itemIn);
        if (itemIn instanceof Block && this.saveTileDataToItem && this.f_31944_ != null) {
            stack.m_41700_("BlockEntityTag", this.f_31944_);
        }
        return this.m_5552_(stack, offset);
    }

    @Override
    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    public void setCancelDrop(boolean cancelDrop) {
        this.f_31947_ = cancelDrop;
    }
}
