package net.mehvahdjukaar.moonlight.api.fluids;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.MapItemDataPacketMixin;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SoftFluidRegistry {

    public static final ResourceKey<Registry<SoftFluid>> KEY = ResourceKey.m_135788_(Moonlight.res("soft_fluids"));

    public static Holder<SoftFluid> getEmpty() {
        return BuiltInSoftFluids.EMPTY.getHolder();
    }

    public static SoftFluid empty() {
        return BuiltInSoftFluids.EMPTY.get();
    }

    public static Registry<SoftFluid> hackyGetRegistry() {
        return Utils.hackyGetRegistry(KEY);
    }

    public static Registry<SoftFluid> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.m_6632_(KEY).orElseThrow();
    }

    public static Collection<SoftFluid> getValues() {
        return hackyGetRegistry().m_123024_().toList();
    }

    public static Collection<Holder.Reference<SoftFluid>> getHolders() {
        return hackyGetRegistry().m_203611_().toList();
    }

    public static Set<Map.Entry<ResourceKey<SoftFluid>, SoftFluid>> getEntries() {
        return hackyGetRegistry().m_6579_();
    }

    public static Holder<SoftFluid> getHolder(ResourceLocation id) {
        var opt = getOptionalHolder(id);
        if (opt.isPresent()) return opt.get();
        return getEmpty();
    }

    public static Optional<Holder.Reference<SoftFluid>> getOptionalHolder(ResourceLocation id) {
        id = backwardsCompat(id);
        return hackyGetRegistry().m_203636_(ResourceKey.m_135785_(KEY, id));
    }

    @NotNull
    private static ResourceLocation backwardsCompat(ResourceLocation id) {
        String namespace = id.m_135827_();
        if (namespace.equals("selene") || namespace.equals("minecraft"))
            id = Moonlight.res(id.m_135815_()); //backwards compat
        return id;
    }
}