package net.mehvahdjukaar.moonlight.api.misc;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;

public interface SlotProvider {
    Iterator<Slot> getSlots(Inventory inv);


    static SlotProvider hand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) return MAIN_HAND;
        else return OFF_HAND;
    }

    static SlotProvider single(int slot) {
        return inv -> List.of(Slot.invSlot(inv, slot)).iterator();
    }

    SlotProvider ALL = inv -> IntStream.range(0, inv.f_35974_.size())
            .mapToObj(i -> Slot.invSlot(inv, i)).iterator();

    SlotProvider OFF_HAND = inv -> IntStream.range(0, inv.f_35976_.size())
            .mapToObj(i -> Slot.offHandSlot(inv, i)).iterator();

    SlotProvider MAIN_HAND = inv -> List.of(Slot.invSlot(inv, inv.f_35977_)).iterator();

    interface Slot {
        ItemStack getStack();

        boolean add(ItemStack stack, Inventory inv, Player player);

        static Slot invSlot(Inventory inv, int slot) {
            return new Slot() {
                @Override
                public ItemStack getStack() {
                    return inv.m_8020_(slot);
                }

                @Override
                public boolean add(ItemStack toAdd, Inventory inv, Player player) {
                    ItemStack current = getStack();
                    //vanilla doesn't do this for some reason... calling add alone will just incrememnt the count of an existing item
                    if (!current.m_41619_() && !inv.m_36014_(current, toAdd)) return false;

                    //same as vanilla .add but no damageable and creative bs logic
                    if (toAdd.m_41619_()) {
                        return false;
                    } else {
                        try {
                            int originalCount;
                            do {
                                originalCount = toAdd.m_41613_();
                                toAdd.m_41764_(inv.m_36047_(slot, toAdd));
                            } while (!toAdd.m_41619_() && toAdd.m_41613_() < originalCount);

                            return toAdd.m_41613_() < originalCount;
                        } catch (Throwable var6) {
                            CrashReport crashReport = CrashReport.m_127521_(var6, "Adding item to inventory");
                            CrashReportCategory crashReportCategory = crashReport.m_127514_("Item being added");
                            crashReportCategory.m_128159_("Item ID", Item.m_41393_(toAdd.m_41720_()));
                            crashReportCategory.m_128159_("Item data", toAdd.m_41773_());
                            crashReportCategory.m_128165_("Item name", () -> toAdd.m_41786_().getString());
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            };


        }

        static Slot offHandSlot(Inventory inv, int offHandSlot) {
            return new Slot() {
                @Override
                public ItemStack getStack() {
                    return inv.f_35976_.get(offHandSlot);
                }

                //copied from Inventory.addResource but for offhand
                @Override
                public boolean add(ItemStack stack, Inventory inv, Player player) {
                    if (stack.m_41619_()) {
                        return false;
                    } else {
                        try {
                            int originalCount;
                            do {
                                originalCount = stack.m_41613_();
                                addResourceOffHand(stack, inv);
                            } while (!stack.m_41619_() && stack.m_41613_() < originalCount);

                            if (stack.m_41613_() == originalCount && player.m_150110_().f_35937_) {
                                stack.m_41764_(0);
                                return true;
                            } else {
                                return stack.m_41613_() < originalCount;
                            }
                        } catch (Throwable var6) {
                            CrashReport crashReport = CrashReport.m_127521_(var6, "Adding item to inventory");
                            CrashReportCategory crashReportCategory = crashReport.m_127514_("Item being added");
                            crashReportCategory.m_128159_("Item ID", Item.m_41393_(stack.m_41720_()));
                            crashReportCategory.m_128159_("Item data", stack.m_41773_());
                            crashReportCategory.m_128165_("Item name", () -> stack.m_41786_().getString());
                            throw new ReportedException(crashReport);
                        }
                    }
                }

                private void addResourceOffHand(ItemStack toAdd, Inventory inv) {
                    Item item = toAdd.m_41720_();
                    int stackCount;
                    NonNullList<ItemStack> offHand = inv.f_35976_;
                    for (int offSlot = 0; offSlot < offHand.size(); offSlot++) {
                        stackCount = toAdd.m_41613_();
                        ItemStack handStack = offHand.get(offSlot);
                        if (handStack.m_41619_()) {
                            handStack = new ItemStack(item, 0);
                            if (toAdd.m_41782_()) {
                                handStack.m_41751_(toAdd.m_41783_().m_6426_());
                            }

                            offHand.set(offSlot, handStack);
                        } else if (!inv.m_36014_(handStack, toAdd)) {
                            continue;
                        }

                        int addedCount = stackCount;
                        if (addedCount > handStack.m_41741_() - handStack.m_41613_()) {
                            addedCount = handStack.m_41741_() - handStack.m_41613_();
                        }

                        if (addedCount > inv.m_6893_() - handStack.m_41613_()) {
                            addedCount = inv.m_6893_() - handStack.m_41613_();
                        }

                        if (addedCount != 0) {
                            stackCount -= addedCount;
                            handStack.m_41769_(addedCount);
                            handStack.m_41754_(5);

                            toAdd.m_41764_(stackCount);
                        }
                    }
                }
            };
        }
    }

}

