package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

//wrapped tag builder for easier use
public class SimpleTagBuilder extends TagBuilder {

    private final Set<String> uniqueKeys = new HashSet<>();
    private final ResourceLocation id;

    protected SimpleTagBuilder(ResourceLocation location) {
        this.id = location;
    }

    public ResourceLocation getId() {
        return id;
    }

    public static SimpleTagBuilder of(ResourceLocation location) {
        return new SimpleTagBuilder(location);
    }

    public static SimpleTagBuilder of(TagKey<?> key) {
        return new SimpleTagBuilder(key.f_203868_());
    }


    public SimpleTagBuilder merge(SimpleTagBuilder other) {
        this.addAll(other.m_215904_());
        return this;
    }

    public SimpleTagBuilder addAll(Collection<TagEntry> entries) {
        entries.forEach(this::m_215902_);
        return this;
    }

    @Override
    public TagBuilder m_215902_(TagEntry entry) {
        if (validateEntry(entry)) {
            return super.m_215902_(entry);
        }
        return this;
    }

    public SimpleTagBuilder add(ResourceLocation entry) {
        super.m_215900_(entry);
        return this;
    }

    public TagBuilder addOptional(ResourceLocation elementLocation) {
        super.m_215905_(elementLocation);
        return this;
    }

    //assure entry is unique
    private boolean validateEntry(TagEntry entry) {
        String string = entry.toString();
        return uniqueKeys.add(string);
    }

    //Forge stuff. we arent using it
    /*
    @Override
    public SimpleTagBuilder replace(boolean value) {
        super.replace(value);
        return this;
    }

    @Override
    public SimpleTagBuilder replace() {
        super.replace();
        return this;
    }*/

    @Override
    public SimpleTagBuilder m_215907_(ResourceLocation pId) {
        super.m_215907_(pId);
        return this;
    }

    public SimpleTagBuilder addTag(TagKey<?> tagKey) {
        return this.m_215907_(tagKey.f_203868_());
    }

    @Override
    public SimpleTagBuilder m_215909_(ResourceLocation pId) {
        super.m_215909_(pId);
        return this;
    }

    public SimpleTagBuilder addTag(SimpleTagBuilder otherBuilder) {
        return this.m_215907_(otherBuilder.getId());
    }

    public SimpleTagBuilder addEntries(Collection<?> entries) {
        entries.forEach(e -> this.add(Utils.getID(e)));
        return this;
    }

    public SimpleTagBuilder addEntry(Object entry) {
        this.add(Utils.getID(entry));
        return this;
    }


    public JsonElement serializeToJson() {
        return TagFile.f_215958_.encodeStart(JsonOps.INSTANCE, new TagFile(this.m_215904_(), false))
                .getOrThrow(false, Moonlight.LOGGER::error);
    }

    public void addFromJson(JsonObject oldTag) {
        TagFile tagfile = TagFile.f_215958_.parse(new Dynamic<>(JsonOps.INSTANCE, oldTag))
                .getOrThrow(false, Moonlight.LOGGER::error);
        if (tagfile.f_215960_()) {
            //TODO: figure oout how to remove stuff
        }
        tagfile.f_215959_().forEach(this::m_215902_);

    }
}
