package net.mehvahdjukaar.moonlight.api.resources.assets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;

public class LangBuilder {

    private final Map<String, String> entries = new LinkedHashMap<>();

    public void addGenericEntry(String key, String translation) {
        entries.put(key, translation);
    }

    public void addEntry(Block block, String translation) {
        entries.put(block.m_7705_(), translation);
    }

    public <T> void addEntry(Registry<T> reg, T entry, String translation) {
        entries.put(Util.m_137492_(reg.m_123023_().m_135782_().m_135815_(), reg.m_7981_(entry)), translation);
    }

    public <T> void addSimpleEntry(Registry<T> reg, T entry) {
        entries.put(Util.m_137492_(reg.m_123023_().m_135782_().m_135815_(), reg.m_7981_(entry)),
                LangBuilder.getReadableName(reg.m_7981_(entry).m_135815_()));
    }

    public void addEntry(Item item, String translation) {
        entries.put(item.m_5524_(), translation);
    }

    public void addEntry(EntityType<?> entityType, String translation) {
        entries.put(entityType.m_20675_(), translation);
    }

    public JsonElement build() {
        JsonObject json = new JsonObject();
        for (var e : entries.entrySet()) {
            json.addProperty(e.getKey(), e.getValue());
        }
        return json;
    }

    public Map<String, String> entries() {
        return entries;
    }


    //utils

    //helper to make lang strings
    public static String getReadableName(String name) {
        return Arrays.stream((name).replace(":", "_").split("_"))
                .map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    /**
     * Attempts grabbing a translated component with the given key and arguments. If none is found it will make the key itself readable
     *
     * @param key       translation key
     * @param arguments optional arguments
     * @return readable component
     */
    public static Component getReadableComponent(String key, String... arguments) {
        Component translated = Component.m_237110_(key, (Object[]) arguments);
        if (translated.getString().equals(key)) {
            StringBuilder aa = new StringBuilder();
            for (String s : arguments) {
                aa.append("_").append(s);
            }
            return Component.m_237113_(LangBuilder.getReadableName(key + aa));
        }
        return translated;
    }


    public static void addDynamicEntry(AfterLanguageLoadEvent lang,
                                       String key, BlockType type, Item item) {
        String base = lang.getEntry(key);
        if (base != null) {
            String typeName = lang.getEntry(type.getTranslationKey());
            if (typeName != null) {
                lang.addEntry(item.m_5524_(), String.format(base, typeName));
            } else Moonlight.LOGGER.error("Could not find translation line for typeName: {}", type.getTranslationKey());
        } else Moonlight.LOGGER.error("Could not find translation line for base: {}", key);
    }

    public static void addDynamicEntry(AfterLanguageLoadEvent lang,
                                       String key, BlockType type, Block block) {
        String base = lang.getEntry(key);
        if (base != null) {
            String typeName = lang.getEntry(type.getTranslationKey());
            if (typeName != null) {
                lang.addEntry(block.m_7705_(), String.format(base, typeName));
            }
        }
    }

    public static void addDynamicEntry(AfterLanguageLoadEvent lang,
                                       String key, BlockType type, EntityType<?> entityType) {
        String base = lang.getEntry(key);
        if (base != null) {
            String typeName = lang.getEntry(type.getTranslationKey());
            if (typeName != null) {
                lang.addEntry(entityType.m_20675_(), String.format(base, typeName));
            }
        }
    }
}
