package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.BaseMapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.*;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockBehaviour.Properties;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;


public class Utils {

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothSides) {
        if (!player.m_9236_().f_46443_ || bothSides)
            player.m_21008_(hand, ItemUtils.m_41817_(oldItem.m_41777_(), player, newItem, player.m_7500_()));
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.m_9236_().f_46443_)
            player.m_21008_(hand, ItemUtils.m_41817_(oldItem.m_41777_(), player, newItem, false));
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        swapItem(player, hand, player.m_21120_(hand), newItem);
    }

    //TODO: add more stuff from item utils

    @Deprecated(forRemoval = true)
    public static void addStackToExisting(Player player, ItemStack stack, boolean avoidEmptyHands) {
        addItemOrDrop(player, stack, avoidEmptyHands ? InvPlacer.handOrExistingOrAnyAvoidEmptyHand(InteractionHand.MAIN_HAND) : InvPlacer.handOrExistingOrAny(InteractionHand.MAIN_HAND));
    }

    /**
     * Adds an item to the player's inventory, uses the given strategy to determine where to place it
     */
    public static void addItemOrDrop(Player player, ItemStack stack, InvPlacer placer) {
        Inventory inv = player.m_150109_();
        placer.or(InvPlacer.DROP).place(stack, inv, player);
    }

    public static void addItemOrDrop(Player player, ItemStack stack) {
        addItemOrDrop(player, stack, InvPlacer.existingOrAny()); //default impl
    }


    //xp bottle logic
    public static int getXPinaBottle(int bottleCount, RandomSource rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; i++) xp += (3 + rand.m_188503_(5) + rand.m_188503_(5));
        return xp;
    }


    public static ResourceLocation getID(@NotNull Block object) {
        return BuiltInRegistries.f_256975_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull EntityType<?> object) {
        return BuiltInRegistries.f_256780_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Biome object) {
        return hackyGetRegistry(Registries.f_256952_).m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull DamageType type) {
        return hackyGetRegistry(Registries.f_268580_).m_7981_(type);
    }

    public static ResourceLocation getID(@NotNull ConfiguredFeature<?, ?> object) {
        return hackyGetRegistry(Registries.f_256911_).m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Item object) {
        return BuiltInRegistries.f_257033_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Fluid object) {
        return BuiltInRegistries.f_257020_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull BlockEntityType<?> object) {
        return BuiltInRegistries.f_257049_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull RecipeSerializer<?> object) {
        return BuiltInRegistries.f_256769_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().m_7981_(object);
    }

    @Deprecated(forRemoval = true)
    public static ResourceLocation getID(@NotNull MapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Potion object) {
        return BuiltInRegistries.f_256980_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull MobEffect object) {
        return BuiltInRegistries.f_256974_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull CreativeModeTab object) {
        return BuiltInRegistries.f_279662_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull StatType<?> object) {
        return BuiltInRegistries.f_256899_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Object object) {
        if (object instanceof Block b) return getID(b);
        if (object instanceof Item b) return getID(b);
        if (object instanceof EntityType<?> b) return getID(b);
        if (object instanceof BlockEntityType<?> b) return getID(b);
        if (object instanceof Biome b) return getID(b);
        if (object instanceof Fluid b) return getID(b);
        if (object instanceof RecipeSerializer<?> b) return getID(b);
        if (object instanceof ConfiguredFeature<?, ?> c) return getID(c);
        if (object instanceof Potion c) return getID(c);
        if (object instanceof MobEffect c) return getID(c);
        if (object instanceof Supplier<?> s) return getID(s.get());
        if (object instanceof SoftFluid s) return getID(s);
        if (object instanceof MapDecorationType<?, ?> s) return getID(s);
        if (object instanceof CreativeModeTab t) return getID(t);
        if (object instanceof DamageType t) return getID(t);
        if (object instanceof StatType<?> t) return getID(t);
        throw new UnsupportedOperationException("Unsupported class type " + object.getClass() + ". Expected a registry entry for a call to Utils.getID()");
    }

    @Deprecated(forRemoval = true)
    public static <T> boolean isTagged(T entry, Registry<T> registry, TagKey<T> tag) {
        return registry.m_263177_(entry).m_203656_(tag);
    }

    //very very hacky
    //attempts to grab the right registry access for the current thread, hopefully matching the logical side one
    @ApiStatus.Experimental
    public static RegistryAccess hackyGetRegistryAccess() {
        var s = PlatHelper.getCurrentServer();
        if (PlatHelper.getPhysicalSide().isClient()) {
            if (s != null && (s.m_18695_() || !MoonlightClient.isClientThread())) return s.m_206579_();
            var level = Minecraft.m_91087_().f_91073_;
            if (level != null) return level.m_9598_();
            var hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
            if (hack2 != null) return hack2.get();
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        if (s != null) return s.m_206579_();
        var hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
        if (hack2 != null) return hack2.get();
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static <T> Registry<T> hackyGetRegistry(ResourceKey<Registry<T>> registry) {
        return hackyGetRegistryAccess().m_175515_(registry);
    }

    /**
     * Copies block properties without keeping stupid lambdas that could include references to the wrong blockstate properties
     */
    public static BlockBehaviour.Properties copyPropertySafe(Block blockBehaviour) {
        var p = BlockBehaviour.Properties.m_60926_(blockBehaviour);
        BlockState state = blockBehaviour.m_49966_();
        p.m_60953_(s -> state.m_60791_());
        p.m_222979_(BlockBehaviour.OffsetType.NONE);
        p.m_60922_((blockState, blockGetter, pos, entityType) ->
                blockState.m_60783_(blockGetter, pos, Direction.UP) && blockState.m_60791_() < 14);
        p.m_284180_(blockBehaviour.m_284356_());
        p.m_60991_((blockState, blockGetter, blockPos) -> false);
        //TODO: this isnt safe anymore... in 1.21
        return p;
    }

    public static BlockHitResult rayTrace(LivingEntity entity, boolean hitsFluids, float partialTicks) {
        return (BlockHitResult) entity.m_19907_(ForgeHelper.getReachDistance(entity), partialTicks, hitsFluids);
    }

    @Deprecated(forRemoval = true)
    public static HitResult rayTrace(LivingEntity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return rayTrace(entity, world, blockMode, fluidMode, ForgeHelper.getReachDistance(entity));
    }

    // use entity.pick
    @Deprecated(forRemoval = true)
    public static HitResult rayTrace(Entity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Vec3 startPos = entity.m_146892_();
        Vec3 ray = entity.m_20252_(1).m_82490_(range);
        Vec3 endPos = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, endPos, blockMode, fluidMode, entity);
        return world.m_45547_(context);
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name) {
        awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name, String unlockProp) {
        Advancement advancement = sp.m_20194_().m_129889_().m_136041_(name);
        if (advancement != null) {
            PlayerAdvancements advancements = sp.m_8960_();
            if (!advancements.m_135996_(advancement).m_8193_()) {
                advancements.m_135988_(advancement, unlockProp);
            }
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? (BlockEntityTicker<A>) ticker : null;
    }

    public static BlockState readBlockState(CompoundTag compound, @Nullable Level level) {
        HolderGetter<Block> holderGetter = level != null ? level.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        return NbtUtils.m_247651_(holderGetter, compound);
    }

    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.m_61138_(property)) {
            return to.m_61124_(property, from.m_61143_(property));
        }
        return to;
    }

    //Use below
    @Deprecated(forRemoval = true)
    public static boolean mayBuild(Player player, BlockPos pos) {
        return mayPerformBlockAction(player, pos, player.m_21205_());
    }

    @Deprecated(forRemoval = true)
    public static boolean mayPerformBlockAction(Player player, BlockPos pos) {
        return mayPerformBlockAction(player, pos, player.m_21205_());
    }

    /**
     * Call this instead of player.abilities.mayBuild. Mainly used for adventure mode ege case
     * <p>
     * This is needed as vanilla handles most of its block altering actions from the item class which calls this.
     * In a Block class this should be called instead to allow adventure mode to work properly
     * <p>
     * Call when placing or modifying a block. Checks edge cases like spectator
     * Needed also in BLOCK use methods. or other places. not item i believe
     */
    public static boolean mayPerformBlockAction(Player player, BlockPos pos, ItemStack stack) {
        GameType gameMode;
        if (player instanceof ServerPlayer sp) {
            gameMode = sp.f_8941_.m_9290_();
        } else {
            gameMode = Minecraft.m_91087_().f_91072_.m_105295_();
        }
        //this only checks the adventure mode canDestroyTag tag
        boolean result = !player.m_36187_(player.m_9236_(), pos, gameMode);
        if (!result) {
            //also checks this because vanilla doesnt as it does not place blocks in block use method
            //also vanilla tends to allow a bunch of unpreventable adventure interactions
            if (gameMode == GameType.ADVENTURE && !stack.m_41619_() &&
                    stack.m_204121_(
                            player.m_9236_().m_9598_().m_175515_(Registries.f_256747_),
                            new BlockInWorld(player.m_9236_(), pos, false)
                    )) {
                return true;
            }
        }
        return result;
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = findMethodWithMatchingName(subclass, name);
        Method modMethod = findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getName().equals(name)) {
                return method;
            }
        }
        return null;
    }


    @ExpectPlatform
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> C optionalMapCodec(final Codec<K> keyCodec, final Codec<V> elementCodec) {
        throw new AssertionError();
    }

    public static ResourceLocation idWithOptionalNamespace(String id, String namespace) {
        if (id.contains(":")) {
            return new ResourceLocation(id);
        } else {
            return new ResourceLocation(namespace, id);
        }
    }

    @Nullable
    public static <T> T findFirstInRegistry(Registry<T> registry, ResourceLocation... ids) {
        for (ResourceLocation r : ids) {
            var optional = registry.m_6612_(r);
            if (optional.isPresent()) return optional.get();
        }
        return null;
    }

    @Nullable
    public static <T> T findFirstInRegistry(Registry<T> registry, Iterable<ResourceLocation> ids) {
        for (ResourceLocation r : ids) {
            var optional = registry.m_6612_(r);
            if (optional.isPresent()) return optional.get();
        }
        return null;
    }


}