package net.mehvahdjukaar.moonlight.core.fake_player;

import com.mojang.authlib.GameProfile;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class FakeLocalPlayer extends AbstractClientPlayer {

    private static final boolean HAS_CACHE = PlatHelper.getPlatform().isForge(); //fabric doesnt have world unload event

    // Map of all active fake player usernames to their entities
    // automatically gets cleaned when level is unloaded as key won't be in use anymore
    private static final WeakHashMap<ClientLevel, Map<GameProfile, FakeLocalPlayer>> FAKE_PLAYERS = new WeakHashMap<>();

    /**
     * Get a fake player with a given username,
     * Mods should either hold weak references to the return value, or listen for a
     * WorldEvent.Unload and kill all references to prevent worlds staying in memory.
     */
    static FakeLocalPlayer get(ClientLevel level, GameProfile username) {
        if (!HAS_CACHE) return new FakeLocalPlayer(level, username);
        return FAKE_PLAYERS.computeIfAbsent(level, l -> new HashMap<>())
                .computeIfAbsent(username, u -> new FakeLocalPlayer(level, username));
    }

    static void unloadLevel(LevelAccessor level) {
        FAKE_PLAYERS.entrySet().removeIf(e -> e.getKey() == level);
    }

    private final EntityDimensions dimensions = EntityDimensions.m_20398_(0, 0);

    public FakeLocalPlayer(ClientLevel pClientLevel, GameProfile pGameProfile) {
        super(pClientLevel, pGameProfile);
        this.f_19794_ = true;
    }

    @Override
    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
    }

    @Override
    public @Nullable MinecraftServer m_20194_() {
        return PlatHelper.getCurrentServer();
    }

    @Override
    public EntityDimensions m_6972_(Pose pose) {
        return dimensions;
    }

    @Override
    public void m_8119_() {
    }

    @Override
    public Vec3 m_20182_() {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    @Override
    public BlockPos m_20183_() {
        return new BlockPos((int) this.m_20185_(), (int) this.m_20186_(), (int) this.m_20189_());
    }

    @Override
    public void m_146926_(float pXRot) {
        super.m_146926_(pXRot);
        this.f_19860_ = pXRot;
    }

    @Override
    public void m_146922_(float pYRot) {
        super.m_146922_(pYRot);
        this.f_19859_ = pYRot;
    }
}
