package net.mehvahdjukaar.moonlight.core.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public class OptionalPropertyCondition implements LootItemCondition {
    @Nullable
    final Block block;
    final StatePropertiesPredicate properties;
    private final ResourceLocation blockId;

    OptionalPropertyCondition(ResourceLocation blockId, Block block, StatePropertiesPredicate predicate) {
        this.properties = predicate;
        this.block = block;
        this.blockId = blockId;
    }

    @Override
    public LootItemConditionType m_7940_() {
        return MoonlightRegistry.LAZY_PROPERTY.get();
    }

    @Override
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of(LootContextParams.f_81461_);
    }

    @Override
    public boolean test(LootContext lootContext) {
        if (block == null) return false;
        BlockState blockState = lootContext.m_78953_(LootContextParams.f_81461_);
        return blockState != null && blockState.m_60713_(this.block) && this.properties.m_67667_(blockState);
    }

    public static class ConditionSerializer implements Serializer<OptionalPropertyCondition> {
        @Override
        public void serialize(JsonObject jsonObject, OptionalPropertyCondition condition, JsonSerializationContext context) {
            jsonObject.addProperty("block", condition.blockId.toString());
            jsonObject.add("properties", condition.properties.m_67666_());
        }

        @Override
        public OptionalPropertyCondition m_7561_(JsonObject jsonObject, JsonDeserializationContext context) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_(jsonObject, "block"));
            Block block = BuiltInRegistries.f_256975_.m_6612_(resourceLocation).orElse(null);
            StatePropertiesPredicate predicate = StatePropertiesPredicate.f_67658_;
            if (block != null) {
                predicate = StatePropertiesPredicate.m_67679_(jsonObject.get("properties"));
                predicate.m_67672_(block.m_49965_(), string -> {
                    throw new JsonSyntaxException("Block " + block + " has no property " + string);
                });
            }

            return new OptionalPropertyCondition(resourceLocation, block, predicate);
        }

    }
}
