package net.mehvahdjukaar.moonlight.core.misc;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AntiRepostWarning {

    private static final Set<String> MODS = new HashSet<>();

    public static void addMod(String id) {
        if (!Objects.equals(id, "minecraft")) {
            MODS.add(id);
        }
    }

    public static void run() {
        if (PlatHelper.isDev()) return;
        Player player = Minecraft.m_91087_().f_91074_;
        if (player == null) return;
        Set<String> reposted = MODS.stream().filter(AntiRepostWarning::isFileNameSus).collect(Collectors.toSet());

        try {
            for (var m : reposted) {
                String url = PlatHelper.getModPageUrl(m);
                if (url == null) url ="https://curseforge.com/minecraft/mc-mods";
                MutableComponent link = Component.m_237115_("message.moonlight.anti_repost_link");
                String modName = PlatHelper.getModName(m);
                MutableComponent name = Component.m_237113_(modName).m_130940_(ChatFormatting.BOLD);

                ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
                link.m_6270_(link.m_7383_().m_131142_(click).m_131162_(true)
                        .m_131148_(TextColor.m_131270_(ChatFormatting.GOLD)));

                player.m_5661_(Component.m_237110_("message.moonlight.anti_repost", name, link), false);

            }
        } catch (Exception ignored) {
        }
    }

    private static boolean isFileNameSus(String mod) {
        var path = PlatHelper.getModFilePath(mod);
        if (path == null || path.getFileName() == null) {
            Moonlight.LOGGER.warn("Failed to get file path of mod {}: {}", mod, path);
        } else {
            String fileName = path.getFileName().toString();
            if (fileName.contains(".jar")) {
                return fileName.contains("-Mod-") || fileName.endsWith("-tw");
            }
        }
        return false;
    }


}
