package net.mehvahdjukaar.moonlight.core.misc;

import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.MultiPackResourceManager;

import java.util.List;
import java.util.Set;

//resource manager that only contains vanilla stuff
public class FilteredResManager extends MultiPackResourceManager {

    public FilteredResManager(PackType packType, List<PackResources> list) {
        super(packType, list);
    }

    public static FilteredResManager including(PackRepository original, PackType packType, String... packs) {
        Set<String> whitelist = Set.of(packs);
        var list = original.m_10519_().stream().filter(p -> whitelist.contains(p.m_10446_()))
                .map(Pack::m_10445_).toList();
        return new FilteredResManager(packType, list);
    }

    public static FilteredResManager excluding(PackRepository original, PackType packType, String... packs) {
        Set<String> blacklist = Set.of(packs);
        var list = original.m_10519_().stream().filter(p -> !blacklist.contains(p.m_10446_()))
                .map(Pack::m_10445_).toList();
        return new FilteredResManager(packType, list);
    }
}
