package net.mehvahdjukaar.moonlight.core.misc;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Schedule;

import java.util.function.Supplier;

public class VillagerAIInternal {


    public static void init() {
    }

    //schedule to which all the tasks are registered to
    public static final Supplier<Schedule> CUSTOM_VILLAGER_SCHEDULE =
            RegHelper.register(Moonlight.res("custom_villager_schedule"), Schedule::new, Registries.f_256723_);


    //called by mixin. Do not call
    public static void onRegisterBrainGoals(Brain<Villager> brain, AbstractVillager villager) {
        if (villager instanceof Villager v) {
            var event = createEvent(brain, v);
            MoonlightEventsHelper.postEvent(event, IVillagerBrainEvent.class);
            //don't waste time if it doesn't have a custom schedule
            var internal = event.getInternal();
            if (internal.hasCustomSchedule()) {
                //finalize schedule
                brain.m_21912_(internal.buildFinalizedSchedule());
                brain.m_21862_(villager.m_9236_().m_46468_(),villager.m_9236_().m_46467_());
            }
        }
    }

    @ExpectPlatform
    public static IVillagerBrainEvent createEvent(Brain<Villager> brain, Villager villager){
        throw new AssertionError();
    }
}
