package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.core.misc.FilteredResManager;
import net.mehvahdjukaar.moonlight.core.misc.ReloadInstanceWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Optional;

@Mixin(MultiPackResourceManager.class)
public abstract class ServerMultiPackResourceManagerMixin implements CloseableResourceManager {

    //since we are on server thread we can use old method of doing stuff since its non blocking
    //must use this way since other one happens too late
    @Shadow
    public abstract Optional<Resource> m_213713_(ResourceLocation arg);

    //should fire right before add reload listener, before packs are reloaded and listeners called
    @Inject(method = "<init>", at = @At(value = "RETURN"))
    private void moonlight$serverDynamicPackEarlyReload(PackType type, List<PackResources> packs, CallbackInfo cir) {
        if(type != PackType.SERVER_DATA) return; //only for server data packs
        //fires on world load or on /reload
        //token to assure that modded resources are included
        if (!((Object) (this) instanceof FilteredResManager) &&
                this.m_213713_(new ResourceLocation("moonlight:moonlight/token.json")).isPresent()) { //this assumes that it includes all pack including all mod assets
            //one would think that this would be fool proof. Well check again, some mod like to re create this resource manager during block load! All modded resources included aswell
            //so to be EXTRA safe we check if registry phase is over
            if (!PlatHelper.isInitializing()) {
                //reload dynamic packs before reloading data packs
                ReloadInstanceWrapper.executeEarlyReloadBlocking(type, this,
                        IProgressTracker.createTree(1));
            }
        }
    }
}

