package net.mehvahdjukaar.moonlight.core.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;


public class ClientBoundOnPistonMovedBlockPacket implements Message {
    public final BlockPos pos;
    private final Direction dir;
    private final BlockState movedState;
    private final boolean extending;

    public ClientBoundOnPistonMovedBlockPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.dir = Direction.m_122376_(buffer.m_130242_());
        this.movedState = buffer.m_236816_(Block.f_49791_);
        this.extending = buffer.readBoolean();
    }

    public ClientBoundOnPistonMovedBlockPacket(BlockPos pos, BlockState movedState, Direction direction, boolean extending) {
        this.pos = pos;
        this.movedState = movedState;
        this.dir = direction;
        this.extending = extending;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.dir.m_122411_());
        buffer.m_236818_(Block.f_49791_, this.movedState);
        buffer.writeBoolean(this.extending);
    }

    @Override
    public void handle(ChannelHandler.Context context) {
        handlePacket(this);
    }

    @Environment(EnvType.CLIENT)
    public static void handlePacket(ClientBoundOnPistonMovedBlockPacket message) {
        var level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            //Haaack. for some reason this gets received before the block there is actually set so we set it preeemptively
            level.m_7731_(message.pos, message.movedState, 0);
            if ( message.movedState.m_60734_() instanceof IPistonMotionReact p) {
                p.onMoved(level, message.pos,  message.movedState, message.dir, message.extending);
            }
        }
    }


}