package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.atomic.AtomicReference;

public class ShapedRecipeTemplate implements IRecipeTemplate<ShapedRecipeBuilder.Result> {

    private final List<Object> conditions = new ArrayList<>();

    public final Item result;
    public final int count;
    public final String group;
    public final List<String> pattern;
    public final Map<Character, Ingredient> keys;
    public final CraftingBookCategory category;

    public ShapedRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        ResourceLocation item = new ResourceLocation(result.get("item").getAsString());
        int count = 1;
        var c = result.get("count");
        if (c != null) count = c.getAsInt();

        this.result = BuiltInRegistries.f_257033_.m_7745_(item);
        this.count = count;
        this.category = CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_(json, "category", null), CraftingBookCategory.MISC);
        var g = json.get("group");
        this.group = g == null ? "" : g.getAsString();

        List<String> patternList = new ArrayList<>();
        JsonArray patterns = json.getAsJsonArray("pattern");
        patterns.forEach(p -> patternList.add(p.getAsString()));

        Map<Character, Ingredient> keyMap = new HashMap<>();
        JsonObject keys = json.getAsJsonObject("key");
        keys.entrySet().forEach((e) -> keyMap.put(e.getKey().charAt(0), Ingredient.m_43917_(e.getValue())));

        this.keys = keyMap;
        this.pattern = patternList;
    }

    public <T extends BlockType> ShapedRecipeBuilder.Result createSimilar(@NotNull T originalMat, @NotNull T destinationMat, Item unlockItem, String id) {
        ItemLike newRes = BlockType.changeItemType(this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                    this.result, originalMat, destinationMat));
        }

        ShapedRecipeBuilder builder = new ShapedRecipeBuilder(determineBookCategory(this.category),
                newRes, this.count);

        boolean atLeastOneChanged = false;
        for (var e : this.keys.entrySet()) {
            Ingredient ing = e.getValue();
            Ingredient newIng = IRecipeTemplate.convertIngredients(originalMat, destinationMat, ing);
            if (newIng != null) {
                atLeastOneChanged = true;
            } else newIng = ing;

            builder.m_126124_(e.getKey(), newIng);
        }
        //if recipe fails
        if (!atLeastOneChanged) return null;

        this.pattern.forEach(builder::m_126130_);
        builder.m_126145_(group);
        builder.m_126132_("has_item", InventoryChangeTrigger.TriggerInstance.m_43199_(unlockItem));

        AtomicReference<ShapedRecipeBuilder.Result> newRecipe = new AtomicReference<>();

        if (id == null) {
            builder.m_176498_(r -> newRecipe.set((ShapedRecipeBuilder.Result) r));
        } else {
            builder.m_176500_(r -> newRecipe.set((ShapedRecipeBuilder.Result) r), id);
        }
        return newRecipe.get();
    }

    @Override
    public List<Object> getConditions() {
        return conditions;
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    public boolean shouldBeShapeless() {
        return this.pattern.size() == 1 && this.pattern.get(0).length() == 1;
    }

    public ShapelessRecipeTemplate toShapeless() {
        return new ShapelessRecipeTemplate(this);
    }
}