package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ShapelessRecipeTemplate implements IRecipeTemplate<ShapelessRecipeBuilder.Result> {

    private final List<Object> conditions = new ArrayList<>();

    public final Item result;
    public final int count;
    public final String group;
    public final List<Ingredient> ingredients;
    public final CraftingBookCategory category;

    ShapelessRecipeTemplate(ShapedRecipeTemplate shaped) {
        this.result = shaped.result;
        this.count = shaped.count;
        this.group = shaped.group;
        this.ingredients = shaped.keys.values().stream().toList();
        this.category = shaped.category;
    }

    public ShapelessRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        ResourceLocation item = new ResourceLocation(result.get("item").getAsString());
        int count = 1;
        var c = result.get("count");
        if (c != null) count = c.getAsInt();

        this.result = BuiltInRegistries.f_257033_.m_7745_(item);
        this.count = count;
        this.category = CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_(json, "category", null), CraftingBookCategory.MISC);

        var g = json.get("group");
        this.group = g == null ? "" : g.getAsString();

        List<Ingredient> ingredientsList = new ArrayList<>();
        JsonArray ingredients = json.getAsJsonArray("ingredients");
        ingredients.forEach(p -> ingredientsList.add(Ingredient.m_43917_(p)));

        this.ingredients = ingredientsList;
    }

    @Override
    public <T extends BlockType> ShapelessRecipeBuilder.Result createSimilar(
            @NotNull T originalMat,@NotNull T destinationMat, Item unlockItem, String id) {
        ItemLike newRes = BlockType.changeItemType(this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                    this.result, originalMat, destinationMat));
        }

        ShapelessRecipeBuilder builder = new ShapelessRecipeBuilder(determineBookCategory(this.category),
                newRes, this.count);

        boolean atLeastOneChanged = false;
        for (var originalIng : this.ingredients) {
            Ingredient newIng = IRecipeTemplate.convertIngredients(originalMat, destinationMat, originalIng);
            if (newIng != null) {
                atLeastOneChanged = true;
            }
            //if fail keep the old one
            else newIng = originalIng;
            builder.m_126184_(newIng);
        }
        //if recipe fails
        if (!atLeastOneChanged) return null;

        builder.m_126145_(group);
        builder.m_126132_("has_item", InventoryChangeTrigger.TriggerInstance.m_43199_(unlockItem));

        AtomicReference<ShapelessRecipeBuilder.Result> newRecipe = new AtomicReference<>();

        if (id == null) {
            builder.m_176498_(r -> newRecipe.set((ShapelessRecipeBuilder.Result) r));
        } else {
            builder.m_176500_(r -> newRecipe.set((ShapelessRecipeBuilder.Result) r), id);
        }
        return newRecipe.get();
    }


    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    @Override
    public List<Object> getConditions() {
        return conditions;
    }
}