/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.core.misc.neoforge.FilteredResManagerImpl;
import net.mehvahdjukaar.moonlight.core.pack.MergedDynamicClientResourcesProvider;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;

public class FilteredResManager
extends MultiPackResourceManager {
    public FilteredResManager(PackType packType, List<PackResources> list) {
        super(packType, list);
    }

    public static FilteredResManager including(ResourceManager original, PackType packType, String ... packs) {
        return FilteredResManager.including(original, packType, (PackResources p) -> Set.of(packs).contains(p.packId()));
    }

    public static FilteredResManager including(ResourceManager original, PackType packType, Predicate<PackResources> predicate) {
        List<PackResources> list = original.listPacks().toList().stream().filter(predicate).toList();
        return new FilteredResManager(packType, list);
    }

    public static FilteredResManager excluding(ResourceManager original, PackType packType, String ... packs) {
        return FilteredResManager.excluding(original, packType, (PackResources p) -> Set.of(packs).contains(p));
    }

    public static FilteredResManager excluding(ResourceManager original, PackType packType, Predicate<PackResources> predicate) {
        List<PackResources> list = original.listPacks().toList().stream().filter(p -> !predicate.test((PackResources)p)).toList();
        return new FilteredResManager(packType, list);
    }

    public static FilteredResManager including(PackRepository original, PackType packType, String ... packs) {
        Set<String> whitelist = Set.of(packs);
        List<PackResources> list = original.getAvailablePacks().stream().filter(p -> whitelist.contains(p.getId())).map(Pack::open).toList();
        return new FilteredResManager(packType, list);
    }

    public static FilteredResManager excluding(PackRepository original, PackType packType, String ... packs) {
        Set<String> blacklist = Set.of(packs);
        List<PackResources> list = original.getAvailablePacks().stream().filter(p -> !blacklist.contains(p.getId())).map(Pack::open).toList();
        return new FilteredResManager(packType, list);
    }

    public static ResourceManager vanilla(ResourceManager manager, PackType type) {
        return FilteredResManager.including(manager, type, (PackResources p) -> {
            String id = p.packId();
            if (id.equals("vanilla")) {
                return true;
            }
            if (FilteredResManager.isDynamicPackResource(p)) {
                return false;
            }
            if (FilteredResManager.isModResourcePack(p)) {
                return true;
            }
            return FilteredResManager.isModResourcePack(p);
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModResourcePack(PackResources pack) {
        return FilteredResManagerImpl.isModResourcePack(pack);
    }

    public static boolean isDynamicPackResource(PackResources p) {
        return p instanceof IEditablePackResources || p instanceof MergedDynamicClientResourcesProvider;
    }
}

