package net.mehvahdjukaar.moonlight.api.client;

import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import net.minecraft.class_758;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

/**
 * Extend to implement more properties
 * <p>
 * Again this just wraps forge stuff. Some of its basic properties are picked up and registered with fabric api
 */
public class ModFluidRenderProperties {

    private final class_2960 flowing;
    private final class_2960 still;
    private final int tint;

    public ModFluidRenderProperties(class_2960 still, class_2960 flowing, int tint) {
        this.still = still;
        this.flowing = flowing;
        this.tint = tint;
        this.afterInit();
    }

    private void afterInit() {
    }

    public ModFluidRenderProperties(class_2960 still, class_2960 flowing) {
        this(still, flowing, 0xFFFFFFFF);
    }


    public int getTintColor() {
        return tint;
    }

    @NotNull
    public class_2960 getStillTexture() {
        return still;
    }

    @NotNull
    public class_2960 getFlowingTexture() {
        return flowing;
    }

    /**
     * the reference of the texture to apply to a fluid directly touching
     * a non-opaque block. Null will call flowing or still textures
     */
    @Nullable
    public class_2960 getOverlayTexture() {
        return null;
    }

    /**
     * Modifies how the fog is currently being rendered when the camera is
     * within a fluid.
     */
    public void modifyFogRender(class_4184 camera, class_758.class_4596 mode, float renderDistance, float partialTick, float nearDistance, float farDistance, class_6854 shape) {
    }

    @NotNull
    public Vector3f modifyFogColor(class_4184 camera, float partialTick, class_638 level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
        return fluidFogColor;
    }

    /**
     * location of the texture to apply to the camera when it is within the fluid
     */
    @Nullable
    public class_2960 getRenderOverlayTexture(class_310 mc)
    {
        return null;
    }


    // Level accessors

    public class_2960 getStillTexture(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getStillTexture();
    }

    public class_2960 getFlowingTexture(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getFlowingTexture();
    }

    public class_2960 getOverlayTexture(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getOverlayTexture();
    }

    public int getTintColor(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getTintColor();
    }

}
