package net.mehvahdjukaar.moonlight.api.client.model.fabric;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.function.Consumer;

public class BakedQuadBuilderImpl implements BakedQuadBuilder {


    public static BakedQuadBuilder create(class_1058 sprite, @Nullable Matrix4f transformation, Consumer<class_777> quadConsumer) {
        return new BakedQuadBuilderImpl(sprite, transformation, quadConsumer);
    }

    private final QuadEmitter inner;
    private final class_1058 sprite;
    private final Matrix4f globalTransform;
    private final Matrix3f normalTransf;
    private final Consumer<class_777> quadConsumer;
    private int vertexIndex = -1;
    private boolean autoDirection = false;

    private BakedQuadBuilderImpl(class_1058 sprite, @Nullable Matrix4f transform, Consumer<class_777> quadConsumer) {
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        this.inner = meshBuilder.getEmitter();
        this.globalTransform = transform; //new Matrix4f(new Matrix3f(transform));
        this.sprite = sprite;
        this.quadConsumer = quadConsumer;
        this.inner.spriteBake(sprite, MutableQuadView.BAKE_LOCK_UV);
        this.normalTransf = transform == null ? null :
                new Matrix3f(transform).invert().transpose(); //forge uses this in quad transform. idk how it works
    }

    @Override
    public BakedQuadBuilder setTint(int tintIndex) {
        inner.colorIndex(tintIndex);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setAutoDirection() {
        this.autoDirection = true;
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setShade(boolean shade) {
        //cant do this on fabric
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setAmbientOcclusion(boolean ambientOcclusion) {
        return this;
    }

    public BakedQuadBuilderImpl setDirection(class_2350 direction) {
        if (globalTransform != null) {
            direction = class_2350.method_23225(globalTransform, direction);
        }
        inner.nominalFace(direction);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl method_22912(float x, float y, float z) {
        tryBaking();
        vertexIndex++;
        if (globalTransform != null) {
            Vector4f v = globalTransform.transform(new Vector4f(x, y, z, 1.0F));
            inner.pos(vertexIndex, v.x(), v.y(), v.z());
            return this;
        }
        inner.pos(vertexIndex, x, y, z);
        return this;
    }


    @Override
    public BakedQuadBuilderImpl method_22914(float x, float y, float z) {
        if (globalTransform != null) {
            Vector3f normal = normalTransf.transform(new Vector3f(x, y, z));
            normal.normalize();
            inner.normal(vertexIndex, normal.x(), normal.y(), normal.z());
        } else inner.normal(vertexIndex, x, y, z);
        if (autoDirection) {
            this.setDirection(class_2350.method_10147(x, y, z));
        }
        return this;
    }

    @Override
    public BakedQuadBuilderImpl method_39415(int rgba) {
        inner.color(vertexIndex, rgba);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl method_1336(int r, int g, int b, int a) {
        return method_39415(((a & 0xFF) << 24) |
                ((b & 0xFF) << 16) |
                ((g & 0xFF) << 8) |
                (r & 0xFF));
    }

    @Override
    public BakedQuadBuilderImpl method_22913(float u, float v) {
        inner.uv(vertexIndex, sprite.method_4580(u * 16), sprite.method_4570(v * 16));
        return this;
    }

    @Override
    public BakedQuadBuilderImpl method_60796(int u, int v) {
        return this;
    }

    @Override
    public BakedQuadBuilderImpl method_22921(int u, int v) {
        inner.lightmap(vertexIndex, (u & 0xFFFF) | ((v & 0xFFFF) << 16));
        return this;
    }

    @Override
    public BakedQuadBuilderImpl lightEmission(int lightLevel) {
        inner.material(RendererAccess.INSTANCE.getRenderer().materialFinder().emissive(true).find());
        return this;
    }

    @Override
    public void close() {
        tryBaking();
    }

    private void tryBaking() {
        if (vertexIndex == 3) {
            vertexIndex = -1;
            Preconditions.checkNotNull(sprite, "sprite cannot be null");
            quadConsumer.accept(inner.toBakedQuad(sprite));
        }
    }

    public BakedQuadBuilder fromVanilla(class_777 quad) {
        inner.fromVanilla(quad, RendererAccess.INSTANCE.getRenderer().materialFinder().find(), quad.method_3358());
        vertexIndex = 3;
        return this;
    }

}

