package net.mehvahdjukaar.moonlight.api.client.util;

import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_727;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL13;

import java.util.function.Supplier;

public class ParticleUtil {

    //call with packet

    public static void spawnParticleInASphere(class_1937 level, double x, double y, double z, Supplier<class_2394> type,
                                              int amount, float speed,
                                              float angleVariation, float speedVariation) {
        double azimuthIncrement = Math.PI * (3 - Math.sqrt(5)); // Golden angle

        for (int i = 0; i < amount; i++) {
            double inclination = Math.acos(1 - (2 * (i + 0.5) / amount)); // Angle from the pole
            double azimuth = azimuthIncrement * i; // Rotation around the axis

            if (angleVariation != 0) {
                inclination += level.field_9229.method_43057() * angleVariation - angleVariation / 2;
                azimuth += level.field_9229.method_43057() * angleVariation - angleVariation / 2;
            }

            float s = speed;
            if (speedVariation != 0) {
                s += level.field_9229.method_43057() * speedVariation - speedVariation / 2;
            }

            double vx = s * Math.sin(inclination) * Math.cos(azimuth);
            double vy = s * Math.sin(inclination) * Math.sin(azimuth);
            double vz = s * Math.cos(inclination);

            level.method_8406(type.get(), x, y, z, vx, vy, vz);
        }
    }

    public static void spawnParticleOnBlockShape(class_1937 level, class_2338 pos, class_2394 particleOptions,
                                                 class_6019 uniformInt, float maxSpeed) {
        spawnParticleOnBoundingBox(level.method_8320(pos).method_26218(level, pos).method_1107().method_996(pos), level,
                particleOptions, uniformInt, maxSpeed);
    }

    public static void spawnParticleOnBoundingBox(class_238 bb, class_1937 level, class_2394 particleOptions,
                                                  class_6019 uniformInt, float maxSpeed) {

        class_5819 random = level.field_9229;
        float offset = 0.1f;
        class_243 blockCenter = new class_243(bb.field_1323 - 0.5 + (bb.field_1320 - bb.field_1323) / 2f, bb.field_1322 - 0.5 + (bb.field_1325 - bb.field_1322) / 2f, bb.field_1321 - 0.5 + (bb.field_1324 - bb.field_1321) / 2f);
        bb = bb.method_989(-blockCenter.field_1352, -blockCenter.field_1351, -blockCenter.field_1350);
        //north
        int i = uniformInt.method_35008(random);
        for (int j = 0; j < i; ++j) {
            double x = random.method_43058();
            double y = random.method_43058();
            if (x > bb.field_1323 && x < bb.field_1320 && y > bb.field_1322 && y < bb.field_1325) {
                double dx = maxSpeed * level.field_9229.method_43058();
                double dy = maxSpeed * level.field_9229.method_43058();
                double dz = 0;
                level.method_8406(particleOptions, blockCenter.field_1352 + x, blockCenter.field_1351 + y, blockCenter.field_1350 + bb.field_1321 - offset, dx, dy, dz);
            }
        }
        //south
        i = uniformInt.method_35008(random);
        for (int j = 0; j < i; ++j) {
            double x = random.method_43058();
            double y = random.method_43058();
            if (x > bb.field_1323 && x < bb.field_1320 && y > bb.field_1322 && y < bb.field_1325) {
                double dx = maxSpeed * level.field_9229.method_43058();
                double dy = maxSpeed * level.field_9229.method_43058();
                double dz = 0;
                level.method_8406(particleOptions, blockCenter.method_10216() + x, blockCenter.method_10214() + y, blockCenter.method_10215() + bb.field_1324 + offset, dx, dy, dz);
            }
        }
        //west
        i = uniformInt.method_35008(random);
        for (int j = 0; j < i; ++j) {
            double z = random.method_43058();
            double y = random.method_43058();
            if (z > bb.field_1321 && z < bb.field_1324 && y > bb.field_1322 && y < bb.field_1325) {
                double dx = 0;
                double dy = maxSpeed * level.field_9229.method_43058();
                double dz = maxSpeed * level.field_9229.method_43058();
                level.method_8406(particleOptions, blockCenter.method_10216() + bb.field_1323 - offset, blockCenter.method_10214() + y, blockCenter.method_10215() + z, dx, dy, dz);
            }
        }
        //east
        i = uniformInt.method_35008(random);
        for (int j = 0; j < i; ++j) {
            double z = random.method_43058();
            double y = random.method_43058();
            if (z > bb.field_1321 && z < bb.field_1324 && y > bb.field_1322 && y < bb.field_1325) {
                double dx = 0;
                double dy = maxSpeed * level.field_9229.method_43058();
                double dz = maxSpeed * level.field_9229.method_43058();
                level.method_8406(particleOptions, blockCenter.method_10216() + bb.field_1320 + offset, blockCenter.method_10214() + y, blockCenter.method_10215() + z, dx, dy, dz);
            }
        }
        //down
        i = uniformInt.method_35008(random);
        for (int j = 0; j < i; ++j) {
            double x = random.method_43058();
            double z = random.method_43058();
            if (x > bb.field_1323 && x < bb.field_1320 && z > bb.field_1321 && z < bb.field_1324) {
                double dx = maxSpeed * level.field_9229.method_43058();
                double dy = 0;
                double dz = maxSpeed * level.field_9229.method_43058();
                level.method_8406(particleOptions, blockCenter.method_10216() + x, blockCenter.method_10214() + bb.field_1322 - offset, blockCenter.method_10215() + z, dx, dy, dz);
            }
        }
        //up
        i = uniformInt.method_35008(random);
        for (int j = 0; j < i; ++j) {
            double x = random.method_43058();
            double z = random.method_43058();
            if (x > bb.field_1323 && x < bb.field_1320 && z > bb.field_1321 && z < bb.field_1324) {
                double dx = maxSpeed * level.field_9229.method_43058();
                double dy = 0;
                double dz = maxSpeed * level.field_9229.method_43058();
                level.method_8406(particleOptions, blockCenter.method_10216() + x, blockCenter.method_10214() + bb.field_1325 + offset, blockCenter.method_10215() + z, dx, dy, dz);
            }
        }
    }


    public static void spawnParticlesOnBlockFaces(class_1937 level, class_2338 pos, class_2394 particleOptions,
                                                  class_6019 uniformInt, float minSpeed, float maxSpeed, boolean perpendicular) {
        for (class_2350 direction : class_2350.values()) {
            int i = uniformInt.method_35008(level.field_9229);

            for (int j = 0; j < i; ++j) {
                spawnParticleOnFace(level, pos, direction, particleOptions, minSpeed, maxSpeed, perpendicular);
            }
        }
    }

    public static void spawnParticleOnFace(class_1937 level, class_2338 pos, class_2350 direction, class_2394 particleOptions,
                                           float minSpeed, float maxSpeed, boolean perpendicular) {
        class_243 vec3 = class_243.method_24953(pos);
        int i = direction.method_10148();
        int j = direction.method_10164();
        int k = direction.method_10165();
        double d0 = vec3.field_1352 + (i == 0 ? class_3532.method_15366(level.field_9229, -0.5D, 0.5D) : i * 0.6D);
        double d1 = vec3.field_1351 + (j == 0 ? class_3532.method_15366(level.field_9229, -0.5D, 0.5D) : j * 0.6D);
        double d2 = vec3.field_1350 + (k == 0 ? class_3532.method_15366(level.field_9229, -0.5D, 0.5D) : k * 0.6D);
        double dx;
        double dy;
        double dz;
        if (perpendicular) {
            dx = i * class_3532.method_32750(level.field_9229, minSpeed, maxSpeed);
            dy = j * class_3532.method_32750(level.field_9229, minSpeed, maxSpeed);
            dz = k * class_3532.method_32750(level.field_9229, minSpeed, maxSpeed);
        } else {
            float d = maxSpeed - minSpeed;

            dx = (i == 0) ? (minSpeed + d * level.field_9229.method_43058()) : 0.0D;
            dy = (j == 0) ? (minSpeed + d * level.field_9229.method_43058()) : 0.0D;
            dz = (k == 0) ? (minSpeed + d * level.field_9229.method_43058()) : 0.0D;
        }
        level.method_8406(particleOptions, d0, d1, d2, dx, dy, dz);
    }


    public static void spawnBreakParticles(class_265 shape, class_2338 pPos, class_2680 pState, class_1937 level) {

        var particleEngine = class_310.method_1551().field_1713;

        shape.method_1089((x0, y0, z0, x1, y1, z1) -> {
            double d1 = Math.min(1.0D, x1 - x0);
            double d2 = Math.min(1.0D, y1 - y0);
            double d3 = Math.min(1.0D, z1 - z0);
            int i = Math.max(2, class_3532.method_15384(d1 / 0.25D));
            int j = Math.max(2, class_3532.method_15384(d2 / 0.25D));
            int k = Math.max(2, class_3532.method_15384(d3 / 0.25D));

            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = (l + 0.5D) / i;
                        double d5 = (i1 + 0.5D) / j;
                        double d6 = (j1 + 0.5D) / k;
                        double d7 = d4 * d1 + x0;
                        double d8 = d5 * d2 + y0;
                        double d9 = d6 * d3 + z0;
                        particleEngine.method_3058(new class_727((class_638) level, pPos.method_10263() + d7, pPos.method_10264() + d8,
                                pPos.method_10260() + d9, d4 - 0.5D, d5 - 0.5D, d6 - 0.5D, pState, pPos));
                    }
                }
            }
        });
    }

}
