package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.NotNull;

/**
 * Improved version of the projectile entity. Combines the functionality of AbstractArrow and ThrowableItemProjectile
 * Main features are:
 * - Improved collision handling, onHit and onBlockHit are called after the pos has been set and not before
 * - Correctly handles weird cases like portal and end portal hit, which arrows and snowballs both do only one of
 * - Collision can now use swept AABB collision instead of ray collision, greatly improving accuracy for blocks
 * - Handy overrides such as spawnTrailParticles and hasReachedEndOfLife
 * - Streamlined deceleration and gravity logic
 */
//TODO: update to 1.21!!!!
public abstract class ImprovedProjectileEntity extends class_3857 {

    private static final class_2940<Byte> ID_FLAGS = class_2945.method_12791(ImprovedProjectileEntity.class, class_2943.field_13319);

    protected class_243 movementOld;

    // Renamed inGround. This is used to check if the projectile is not moving
    protected boolean isStuck = false;
    protected int stuckTime = 0;

    protected int maxAge = 300;
    protected int maxStuckTime = 20;

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1937 world) {
        super(type, world);
        this.movementOld = this.method_18798();
        //remember to add STEP_HEIGHT attribute!
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, double x, double y, double z, class_1937 world) {
        this(type, world);
        this.method_5814(x, y, z);
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1309 thrower, class_1937 world) {
        this(type, thrower.method_23317(), thrower.method_23320() - 0.1F, thrower.method_23321(), world);
        this.method_7432(thrower);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ID_FLAGS, (byte) 0);
    }

    public boolean hasLeftOwner() {
        return this.field_23740;
    }

    //mix of projectile + arrow code to do what both do+  fix some issues
    @SuppressWarnings("ConstantConditions")
    @Override
    public void method_5773() {
        //entity has this param. we sync them for consistency
        this.field_5960 = this.isNoPhysics();

        // Projectile tick stuff
        if (!this.field_28646) {
            this.method_32875(class_5712.field_28161, this.method_24921());
            this.field_28646 = true;
        }
        if (!this.field_23740) {
            this.field_23740 = this.method_26961();
        }

        this.method_5670();

        if (this.hasReachedEndOfLife() && !method_31481()) {
            this.reachedEndOfLife();
        }

        // end of projectile tick stuff

        // AbstractArrow + ThrowableProjectile stuff

        //fixed vanilla arrow code. You're welcome
        class_1937 level = this.method_37908();
        class_243 movement = this.method_18798();
        this.movementOld = movement;

        if (this.field_17046.method_1027() > 1.0E-7) {
            movement = movement.method_18806(this.field_17046);
            this.field_17046 = class_243.field_1353;
            this.method_18799(class_243.field_1353);
        }

        if (!this.field_5960 && this.isStuck) {
            this.stuckTime++;
        }else {
            this.stuckTime = 0;
        }

        this.method_5784(class_1313.field_6308, movement);

        // rest stuff
        this.method_36974();
        this.updateFireState();

        // after we finished moving we can apply forces and  particles

        // update movement and particles
        float deceleration = this.method_5799() ? this.getWaterInertia() : this.getInertia();

        this.method_18799(this.method_18798().method_1021(deceleration));
        if (!this.method_5740() && !field_5960) {
            this.method_18799(this.method_18798().method_1023(0, this.method_56989(), 0));
        }

        if (!isStuck) {
            if (level.field_9236) {
                this.spawnTrailParticles();
            }

            this.method_26962();
        }

        // check if stuck
        this.isStuck = !this.field_5960 && this.method_19538().method_1023(this.field_6014, this.field_6036, this.field_5969).method_1027() < (0.0001 * 0.0001);

    }

    private void updateFireState() {
        //copied bit from move method. Extracted for clarity
        this.field_28629 = this.method_5809();

        if (this.method_37908().method_29556(this.method_5829().method_1011(1.0E-6)).noneMatch((arg) ->
                arg.method_26164(class_3481.field_21952) || arg.method_27852(class_2246.field_10164))) {
            if (this.method_20802() <= 0) {
                this.method_20803(-this.method_5676());
            }

            if (this.field_28629 && (this.field_27857 || this.method_5637() ||
                    ForgeHelper.isInFluidThatCanExtinguish(this))) {
                this.method_36975();
            }
        }

        if (this.method_5809() && (this.field_27857 || this.method_5637() || ForgeHelper.isInFluidThatCanExtinguish(this))) {
            this.method_20803(-this.method_5676());
        }
    }

    /**
     * Tries moving this entity by movement amount.
     * Does all the checks it needs and calls onHit if it hits something.
     * This was made from entity.move  + much stuff from both arrow and projectile code.
     * Does not check for fall damage or other living entity specific stuff
     * If blocks are hit movement is not modified. You need to react in onHitBlock if you wish to do so
     * Movement isn't modified at all here.
     * On fallOn isn't called as we call onProjectile hit. Projectiles dont fall.
     *
     * @param movement amount to travel by
     */
    @Override
    public void method_5784(class_1313 moverType, class_243 movement) {
        // use normal movement logic if not self.. idk why compat i guess incase we were to use ray collider
        // also ued for no physics as that will just set the pos without doing any collision
        if (moverType != class_1313.field_6308 || this.field_5960) {
            super.method_5784(moverType, movement);
            return;
        }

        movement = this.method_18796(movement, moverType);

        class_1937 level = this.method_37908();
        class_243 pos = this.method_19538();

        // Applies collisions calculating hit face and new pos
        ColliderType colliderType = this.getColliderType();

        class_239 hitResult = switch (colliderType) {
            case RAY -> level.method_17742(new class_3959(pos, pos.method_1019(movement),
                    class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this));
            case AABB -> MthUtils.collideWithSweptAABB(this, movement, 2);
            case ENTITY_COLLIDE -> {
                class_243 vec3 = this.method_17835(movement);
                class_243 sub = vec3.method_1020(movement);
                yield vec3 == movement ? class_3965.method_17778(pos.method_1019(vec3), class_2350.field_11036,
                        class_2338.method_49638(pos.method_1019(vec3))) : new class_3965(pos.method_1019(vec3),
                        class_2350.method_10142(sub.field_1352, sub.field_1351, sub.field_1350), class_2338.method_49638(pos.method_1019(vec3)), false);
            }
        };

        class_243 newPos = hitResult.method_17784();
        class_243 newMovement = newPos.method_1020(pos);
        this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);

        //this is mainly used for players
        boolean bl = !class_3532.method_20390(newMovement.field_1352, movement.field_1352);
        boolean bl2 = !class_3532.method_20390(newMovement.field_1350, movement.field_1350);
        this.field_5976 = bl || bl2;
        this.field_5992 = newMovement.field_1351 != movement.field_1351;
        this.field_36331 = this.field_5992 && newMovement.field_1351 < 0.0;
        if (this.field_5976) {
            this.field_34927 = this.method_39759(newMovement);
        } else {
            this.field_34927 = false;
        }

        //try hit entity
        class_3966 entityHitResult = class_1675.method_18077(level, this, pos, newPos,
                this.method_5829().method_18804(newPos.method_1020(pos)).method_1014(1.0D), this::method_26958);

        if (entityHitResult != null) {
            hitResult = entityHitResult;
        }

        boolean portalHit = false;
        if (hitResult instanceof class_3966 ei) {
            class_1297 hitEntity = ei.method_17782();
            if (hitEntity == this.method_24921()) {
                if (!canHarmOwner()) {
                    hitResult = null;
                }
            } else if (hitEntity instanceof class_1657 p1 && this.method_24921() instanceof class_1657 p2 && !p2.method_7256(p1)) {
                hitResult = null;
            }
        } else if (hitResult instanceof class_3965 bi) {
            //portals. done here and not in onBlockHit to prevent any further calls
            class_2338 hitPos = bi.method_17777();
            class_2680 hitState = level.method_8320(hitPos);
            //ThrowableProjectile
            //TODO:!!!! fafactor this whole class!!
            if (hitState.method_27852(class_2246.field_10316)) {
                //this.handleInsidePortal(hitPos);
              //  portalHit = true;
            } else if (hitState.method_27852(class_2246.field_10613)) {
                //if (level.getBlockEntity(hitPos) instanceof TheEndGatewayBlockEntity tile && TheEndGatewayBlockEntity.canEntityTeleport(this)) {
                  //  TheEndGatewayBlockEntity.teleportEntity(level, hitPos, hitState, this, tile);
                //}
               // portalHit = true;
            }
        }

        if (!portalHit && hitResult != null && hitResult.method_17783() != class_239.class_240.field_1333 &&
                !ForgeHelper.onProjectileImpact(this, hitResult)) {
            this.method_7488(hitResult);
        }
    }

    public boolean canHarmOwner() {
        if (method_24921() instanceof class_1657) {
            return method_37908().method_8407().method_5461() >= 1;
        }
        return false;
    }

    protected float getInertia() {
        // normally 0.99 for everything
        return 0.99F;
    }

    protected float getWaterInertia() {
        // normally 0.6 for arrows and 0.99 for tridents and 0.8 for other projectiles
        return 0.6F;
    }

    /**
     * do stuff before removing, then call remove. Called when age reaches max age
     */
    public boolean hasReachedEndOfLife() {
        return this.field_6012 > this.maxAge || this.stuckTime > maxStuckTime;
    }

    /**
     * remove condition
     */
    public void reachedEndOfLife() {
        this.method_5650(class_5529.field_26999);
    }

    public void spawnTrailParticles() {

        if (this.method_5799()) {
            // Projectile particle code
            var movement = this.method_18798();
            double velX = movement.field_1352;
            double velY = movement.field_1351;
            double velZ = movement.field_1350;
            for (int j = 0; j < 4; ++j) {
                double pY = this.method_23320();
                method_37908().method_8406(class_2398.field_11247,
                        method_23317() - velX * 0.25D, pY - velY * 0.25D, method_23321() - velZ * 0.25D,
                        velX, velY, velZ);
            }
        }
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("stuck", this.isStuck);
        tag.method_10569("stuckTime", this.stuckTime);
        tag.method_10556("noPhysics", this.isNoPhysics());
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.isStuck = tag.method_10577("stuck");
        this.stuckTime = tag.method_10550("stuckTime");
        this.setNoPhysics(tag.method_10577("noPhysics"));
    }

    @Override
    public void method_24919(class_1297 shooter, float x, float y, float z, float velocity, float inaccuracy) {
        super.method_24919(shooter, x, y, z, velocity, inaccuracy);
    }

    @Override
    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        super.method_7485(x, y, z, velocity, inaccuracy);
    }

    // Has no effect. Give this to shoot method manually
    public float getDefaultShootVelocity() {
        return 1.5F;
    }

    protected void setFlag(int id, boolean value) {
        byte b0 = this.field_6011.method_12789(ID_FLAGS);
        if (value) {
            this.field_6011.method_12778(ID_FLAGS, (byte) (b0 | id));
        } else {
            this.field_6011.method_12778(ID_FLAGS, (byte) (b0 & ~id));
        }
    }

    protected boolean getFlag(int id) {
        return (this.field_6011.method_12789(ID_FLAGS) & id) != 0;
    }

    // 2 cause its same as arrows for consistency
    public void setNoPhysics(boolean noPhysics) {
        this.field_5960 = noPhysics;
        this.setFlag(2, noPhysics);
    }

    public boolean isNoPhysics() {
        return this.getFlag(2);
    }

    /**
     * AABB: Swept AABB collision, gives very accurate block collisions and stops the entity on the first detected collision
     * RAY: Ray collision, fast but only accurate in the center of the projectile. Ok to use for small projectiles. What arrows use
     */
    protected ColliderType getColliderType() {
        return ColliderType.AABB;
    }

    protected enum ColliderType {
        RAY,
        AABB,
        ENTITY_COLLIDE
    }
}
