package net.mehvahdjukaar.moonlight.api.fluids;

import ;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7226;
import net.minecraft.class_7871;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.core.*;
import net.minecraft.core.component.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.ArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

// do NOT have these in a static field as they contain registry holders
public class SoftFluidStack implements class_9322 {

    public static final Codec<SoftFluidStack> CODEC = RecordCodecBuilder.create(i -> i.group(
            SoftFluid.HOLDER_CODEC.fieldOf("id").forGetter(SoftFluidStack::getHolder),
            class_5699.field_33441.optionalFieldOf("count", 1).forGetter(SoftFluidStack::getCount),
            class_9326.field_49589.optionalFieldOf("components", class_9326.field_49588)
                    .forGetter(stack -> stack.components.method_57940())
    ).apply(i, SoftFluidStack::of));

    public static final class_9139<class_9129, SoftFluidStack> STREAM_CODEC = class_9139.method_56436(
            SoftFluid.STREAM_CODEC, SoftFluidStack::getHolder,
            class_9135.field_48550, SoftFluidStack::getCount,
            class_9326.field_49590, s -> s.components.method_57940(),
            SoftFluidStack::of
    );

    // dont access directly
    private final class_6880<SoftFluid> fluidHolder;
    private final SoftFluid fluid; //reference to avoid calling value all the times. these 2 should always match
    private int count;
    @NotNull
    private final class_9335 components;
    private boolean isEmptyCache;
    private final class_6880<SoftFluid> myEmptyFluid;

    protected SoftFluidStack(class_6880<SoftFluid> fluid, int count, class_9326 components) {
        this.fluidHolder = fluid;
        if (components == null) {
            //TODO: remove me
            Moonlight.LOGGER.error("Some mod passed a null components, fix me");
            components = class_9326.field_49588;
        }
        //validate
        //cant have this because stuff likes to create these from netty thread
        this.fluid = this.fluidHolder.comp_349();
        this.components = class_9335.method_57935(class_9323.field_49584, Objects.requireNonNull(components, "component map cant be null"));
        this.count = count;
        this.updateEmpty();

        this.myEmptyFluid = haxFindEmpty(fluidHolder);
    }

    private class_6880<SoftFluid> haxFindEmpty(class_6880<SoftFluid> fluidHolder) {
        var ra = Utils.hackyFindRegistryOf(fluidHolder, SoftFluidRegistry.KEY);
        return MLBuiltinSoftFluids.EMPTY.lookup(ra);
    }

    @ExpectPlatform
    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count, @NotNull class_9326 tag) {
        throw new AssertionError();
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count) {
        return of(fluid, count, class_9326.field_49588);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid) {
        return of(fluid, 1);
    }

    public static SoftFluidStack bucket(class_6880<SoftFluid> fluid) {
        return of(fluid, SoftFluid.BUCKET_COUNT);
    }

    public static SoftFluidStack bowl(class_6880<SoftFluid> fluid) {
        return of(fluid, SoftFluid.BOWL_COUNT);
    }

    public static SoftFluidStack bottle(class_6880<SoftFluid> fluid) {
        return of(fluid, SoftFluid.BOTTLE_COUNT);
    }

    public static SoftFluidStack fromFluid(class_3611 fluid, int amount) {
        return fromFluid(fluid, amount, class_9326.field_49588);
    }

    @Deprecated(forRemoval = true)
    @NotNull
    public static SoftFluidStack fromFluid(class_3611 fluid, int amount, @NotNull class_9326 component) {
        class_5455 reg = Utils.hackyGetRegistryAccess();
        return fromFluid(fluid, amount, component, reg);
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3611 fluid, int amount, @NotNull class_9326 component, class_7225.class_7874 reg) {
        class_6880<SoftFluid> f = SoftFluidInternal.fromVanillaFluid(fluid, reg);
        if (f == null) return empty(reg);
        return of(f, amount, component);
    }

    @Deprecated(forRemoval = true)
    @NotNull
    public static SoftFluidStack fromFluid(class_3610 fluid) {
        return fromFluid(fluid, Utils.hackyGetRegistryAccess());
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3610 fluid, class_7225.class_7874 reg) {
        if (fluid.method_15767(class_3486.field_15517)) {
            return fromFluid(fluid.method_15772(), SoftFluid.WATER_BUCKET_COUNT, class_9326.field_49588, reg);
        }
        return fromFluid(fluid.method_15772(), SoftFluid.BUCKET_COUNT, class_9326.field_49588, reg);
    }

    @Deprecated(forRemoval = true)
    public static SoftFluidStack empty() {
        return of(SoftFluidRegistry.hackyGetEmpty(), 0);
    }

    public static SoftFluidStack empty(class_7225.class_7874 lookupProvider) {
        return of(SoftFluidRegistry.getEmpty(lookupProvider), 0);
    }

    public static SoftFluidStack empty(class_7871<SoftFluid> reg) {
        return of(SoftFluidRegistry.getEmpty(reg), 0);
    }

    public class_2561 getDisplayName() {
        if (MLBuiltinSoftFluids.POTION.is(this.fluidHolder)) {
            PotionBottleType bottle = PotionBottleType.getOrDefault(this);
            return bottle.getTranslatedName();
        }
        return this.fluid().getTranslatedName();
    }

    public class_2520 save(class_7225.class_7874 lookupProvider) {
        var a = CODEC.encodeStart(lookupProvider.method_57093(class_2509.field_11560), this);
        if (a.isSuccess()) return a.getOrThrow();
        else {
            Moonlight.LOGGER.error("Failed to encode fluid stack. HOW??, {}", a.error().get());
            if (PlatHelper.isDev()) a.getOrThrow();
            return new class_2487();
        }
    }

    public static SoftFluidStack load(class_7225.class_7874 lookupProvider, class_2520 tag) {
        //TODO: add components backwards compat
        return CODEC.parse(lookupProvider.method_57093(class_2509.field_11560), tag).getOrThrow();
    }

    public boolean is(HolderReference<SoftFluid> fluid) {
        return fluid.is(this.fluidHolder);
    }

    public boolean is(class_6862<SoftFluid> tag) {
        return getHolder().method_40220(tag);
    }

    public boolean is(class_5321<SoftFluid> location) {
        return getHolder().method_40225(location);
    }

    @Deprecated(forRemoval = true)
    public boolean is(SoftFluid fluid) {
        return this.fluid() == fluid;
    }

    public boolean is(class_6880<SoftFluid> fluid) {
        return fluid == this.fluidHolder || fluid.method_40225(this.fluidKey());
    }

    @Deprecated(forRemoval = true)
    private class_6880<SoftFluid> getFluid() {
        return isEmptyCache ? myEmptyFluid : fluidHolder;
    }

    public final class_6880<SoftFluid> getHolder() {
        return isEmptyCache ? myEmptyFluid : fluidHolder;
    }

    public final SoftFluid fluid() {
        return isEmptyCache ? myEmptyFluid.comp_349() : fluid;
    }

    public final class_5321<SoftFluid> fluidKey() {
        return getHolder().method_40230().get();
    }

    public boolean isEmpty() {
        return isEmptyCache;
    }

    protected void updateEmpty() {
        isEmptyCache = count <= 0 || MLBuiltinSoftFluids.EMPTY.is(fluidHolder);
    }

    public int getCount() {
        return isEmptyCache ? 0 : count;
    }

    public void setCount(int count) {
        if (MLBuiltinSoftFluids.EMPTY.is(fluidHolder)) {
            if (PlatHelper.isDev()) throw new AssertionError();
            return;
        }
        this.count = count;
        updateEmpty();
    }

    public void grow(int amount) {
        setCount(this.count + amount);
    }

    public void shrink(int amount) {
        setCount(this.count - amount);
    }

    public void consume(int amount, @Nullable class_1309 entity) {
        if (entity == null || !entity.method_56992()) {
            this.shrink(amount);
        }
    }

    public SoftFluidStack copy() {
        return of(getHolder(), count, components.method_57941().method_57940());
    }

    public SoftFluidStack copyWithCount(int count) {
        SoftFluidStack stack = this.copy();
        if (!stack.isEmpty()) {
            stack.setCount(count);
        }
        return stack;
    }

    public SoftFluidStack split(int amount) {
        int i = Math.min(amount, this.getCount());
        SoftFluidStack stack = this.copyWithCount(i);
        if (!this.isEmpty()) this.shrink(i);
        return stack;
    }

    /**
     * Checks if the fluids and NBT Tags are equal. This does not check amounts.
     */
    public boolean isSameFluidSameComponents(SoftFluidStack other) {
        if (!this.is(other.getHolder())) {
            return false;
        } else {
            return this.isEmpty() && other.isEmpty() || Objects.equals(this.components, other.components);
        }
    }

    /**
     * Hashes the fluid and components of this stack, ignoring the amount.
     */
    public static int hashFluidAndComponents(@Nullable SoftFluidStack stack) {
        if (stack != null) {
            int i = 31 + stack.getHolder().hashCode();
            return 31 * i + stack.method_57353().hashCode();
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SoftFluidStack that)) return false;
        return count == that.count && Objects.equals(fluidHolder.method_40230(), that.fluidHolder.method_40230()) && Objects.equals(components, that.components);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fluidHolder.method_40230(), count, components);
    }

    @Override
    public String toString() {
        return this.getCount() + " " + this.getHolder();
    }

    // item conversion

    @Deprecated(forRemoval = true)
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(class_1799 itemStack) {
        return fromItem(itemStack, Utils.hackyGetRegistryAccess());
    }

    @Nullable
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(class_1799 itemStack, class_7225.class_7874 reg) {
        class_1792 filledContainer = itemStack.method_7909();
        class_6880<SoftFluid> fluid = SoftFluidInternal.fromVanillaItem(filledContainer, reg);

        if (fluid != null && !MLBuiltinSoftFluids.EMPTY.is(fluid)) {
            var category = fluid.comp_349().getContainerList()
                    .getCategoryFromFilled(filledContainer);

            if (category.isPresent()) {

                int count = category.get().getCapacity();

                class_9326.class_9327 fluidComponents = class_9326.method_57841();

                //convert potions to water bottles
                class_1844 potion = itemStack.method_57825(class_9334.field_49651, class_1844.field_49274);
                if (potion.method_57401(class_1847.field_8991)) {
                    fluid = MLBuiltinSoftFluids.WATER.getHolder(reg);
                }
                //add tags to splash and lingering potions
                else if (potion.method_57405()) {
                    PotionBottleType bottleType = PotionBottleType.getOrDefault(filledContainer);
                    fluidComponents.method_57854(MoonlightRegistry.BOTTLE_TYPE.get(), bottleType);
                }
                SoftFluidStack sfStack = SoftFluidStack.of(fluid, count, fluidComponents.method_57852());

                copyComponentsTo(itemStack, sfStack, fluid.comp_349().getPreservedComponents());

                return Pair.of(sfStack, category.get());
            }
        }
        return null;
    }


    /**
     * Converts to item and decrement the stack by extracted amount
     */
    public Pair<class_1799, FluidContainerList.Category> splitToItem(class_1799 emptyContainer) {
        var r = toItem(emptyContainer);
        if (r != null) this.shrink(r.getSecond().getCapacity());
        return r;
    }

    @Deprecated(forRemoval = true)
    public Pair<class_1799, FluidContainerList.Category> toItem(class_1799 emptyContainer, boolean dontModifyStack) {
        var r = toItem(emptyContainer);
        if (r != null && !dontModifyStack) this.shrink(r.getSecond().getCapacity());
        return r;
    }

    /**
     * Fills the item if possible. Returns empty stack if it fails
     *
     * @param emptyContainer empty bottle item
     * @return null if it fails, filled stack otherwise
     */
    @Nullable
    public Pair<class_1799, FluidContainerList.Category> toItem(class_1799 emptyContainer) {
        var opt = fluid().getContainerList().getCategoryFromEmpty(emptyContainer.method_7909());
        if (opt.isPresent()) {
            FluidContainerList.Category category = opt.get();
            var filledStacks = createFilledStacks(category, true);
            if (filledStacks.length != 0) {
                // still return only the *first* one, to stay consistent
                return Pair.of(filledStacks[0], category);
            }
        }
        return null;
    }

    public Multimap<FluidContainerList.Category, class_1799> toAllPossibleFilledItems() {
        Multimap<FluidContainerList.Category, class_1799> result = ArrayListMultimap.create();

        for (FluidContainerList.Category category : fluid().getContainerList()) {
            for (class_1799 filled : createFilledStacks(category,false)) {
                result.put(category, filled);
            }
        }

        return result;
    }

    private class_1799[] createFilledStacks(FluidContainerList.Category category, boolean onlyFirst) {
        int shrinkAmount = category.getCapacity();
        if (shrinkAmount > this.getCount()) {
            return new class_1799[0];
        }

        List<class_1799> results = new ArrayList<>();

        for (class_1935 item : category.getFilledItems()) {
            class_1799 filledStack = new class_1799(item);

            // hardcoded potion handling
            if (category.getEmptyContainer() == class_1802.field_8469 && this.is(MLBuiltinSoftFluids.POTION)) {
                PotionBottleType type = PotionBottleType.getOrDefault(this);
                filledStack = type.getDefaultItem();
            }

            // converts water bottles into potions
            if (category.getEmptyContainer() == class_1802.field_8469 && this.is(MLBuiltinSoftFluids.WATER)) {
                filledStack = class_1844.method_57400(class_1802.field_8574, class_1847.field_8991);
            }

            this.copyComponentsTo(filledStack);
            results.add(filledStack);

            if (onlyFirst) {
                break;
            }
        }

        return results.toArray(new class_1799[0]);
    }




    public void copyComponentsTo(class_9322 to) {
        copyComponentsTo(this, to, this.fluid.getPreservedComponents());
    }

    //handles special nbt items such as potions or soups
    protected static void copyComponentsTo(class_9322 from,
                                           class_9322 to,
                                           class_6885<class_9331<?>> types) {
        for (class_6880<class_9331<?>> h : types) {
            //ignores bottle tag, handled separately since it's a diff item
            class_9331<?> type = h.comp_349();
            copyComponentTo(from, to, type);
        }
    }

    private static <A> void copyComponentTo(class_9322 from, class_9322 to, class_9331<A> comp) {
        var componentValue = from.method_57824(comp);
        if (componentValue != null) {
            if (to instanceof class_1799 is)
                is.method_57379(comp, componentValue);
            else if (to instanceof SoftFluidStack sf)
                sf.set(comp, componentValue);
            else PlatHelper.setComponent(to, comp, componentValue);
        }
    }


    // fluid delegates

    public FluidContainerList getContainerList() {
        return fluid().getContainerList();
    }

    public FoodProvider getFoodProvider() {
        return fluid().getFoodProvider();
    }

    public boolean isEquivalent(class_6880<class_3611> fluid) {
        return this.isEquivalent(fluid, class_9326.field_49588);
    }

    public boolean isEquivalent(class_6880<class_3611> fluid, class_9326 componentPatch) {
        return this.fluid().isEquivalent(fluid) && Objects.equals(this.components.method_57940(), componentPatch);
    }

    public class_6880<class_3611> getVanillaFluid() {
        return this.fluid().getVanillaFluid();
    }

    /**
     * Client only
     *
     * @return tint color to be applied on the fluid texture
     */
    public int getStillColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid fluid = this.fluid();
        SoftFluid.TintMethod method = fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) return -1;
        int specialColor = SoftFluidColors.getSpecialColor(this, world, pos);

        if (specialColor != 0) return specialColor;
        return fluid.getTintColor();
    }

    /**
     * Client only
     *
     * @return tint color to be applied on the fluid texture
     */
    public int getFlowingColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid.TintMethod method = this.fluid().getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) return this.getParticleColor(world, pos);
        else return this.getStillColor(world, pos);
    }

    /**
     * Client only
     *
     * @return tint color to be used on particle. Differs from getTintColor since it returns an mixWith color extrapolated from their fluid textures
     */
    public int getParticleColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        int tintColor = getStillColor(world, pos);
        //if tint color is white gets averaged color
        if (tintColor == -1) return this.fluid().getAverageTextureTintColor();
        return tintColor;
    }

    @Override
    public @NotNull class_9335 method_57353() {
        return this.components;
    }

    @Nullable
    public <T> T set(class_9331<? super T> type, @Nullable T component) {
        return this.components.method_57938(type, component);
    }


}
