package net.mehvahdjukaar.moonlight.api.map.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.integration.MapAtlasCompat;
import net.minecraft.class_1058;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

public class MapDecorationRenderer<T extends MLMapDecoration> {
    protected final class_2960 textureId;

    public MapDecorationRenderer(class_2960 texture) {
        this.textureId = texture;
    }

    protected int getColor(T decoration) {
        return -1;
    }

    protected int getAlpha(T decoration) {
        return 255;
    }

    protected boolean hasOutline(T decoration) {
        return false;
    }

    protected boolean rendersOnFrame(T decoration) {
        return true;
    }

    public boolean render(T decoration, class_4587 matrixStack, class_4588 vertexBuilder,
                          class_4597 buffer,
                          @Nullable class_22 mapData,
                          boolean isOnFrame, int light, int index) {
        return render(decoration, matrixStack, vertexBuilder, buffer, mapData, isOnFrame, light, index, true);
    }

    public boolean render(T decoration, class_4587 matrixStack, class_4588 vertexBuilder,
                          class_4597 buffer,
                          @Nullable class_22 mapData,
                          boolean isOnFrame, int light, int index, boolean rendersText) {
        if (!isOnFrame || rendersOnFrame(decoration)) {

            matrixStack.method_22903();
            matrixStack.method_46416(0.0F + (float) decoration.getX() / 2.0F + 64.0F, 0.0F + (float) decoration.getY() / 2.0F + 64.0F, -0.02F);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float) (decoration.getRot() * 360) / 16.0F));
            matrixStack.method_22905(4.0F, 4.0F, 3.0F);
            if (CompatHandler.MAP_ATLASES) {
                MapAtlasCompat.scaleDecoration(matrixStack);
            }
            //matrixStack.translate(-0.125D, 0.125D, 0.0D);

            renderDecorationSprite(matrixStack, buffer, vertexBuilder, light, index,
                    this.getColor(decoration), this.getAlpha(decoration), this.hasOutline(decoration));

            matrixStack.method_22909();

            if (decoration.getDisplayName() != null && rendersText) {
                renderName(decoration, matrixStack, buffer, light);
            }
            return true;
        }
        return false;
    }


    // renders centered sprite
    public void renderDecorationSprite(class_4587 matrixStack, class_4597 buffer, class_4588 vertexBuilder, int light, int index,
                                       int color, int alpha, boolean outline) {

        int b = class_5253.class_5254.method_27767(color);
        int g = class_5253.class_5254.method_27766(color);
        int r = class_5253.class_5254.method_27765(color);

        RenderSystem.enableDepthTest();
        class_1058 sprite = class_310.method_1551().method_58476().method_18667(textureId);
        //so we can use local coordinates
        //idk wy wrap doesnt work, it does the same as here
        //vertexBuilder = sprite.wrap(vertexBuilder);

        if (alpha != 0) {
            matrixStack.method_22903();
            matrixStack.method_46416(0,0,index * -0.001F);
            RenderUtil.renderSprite(matrixStack, vertexBuilder, light, b, g, r, alpha, sprite);

            if (outline) {
                //we cant tint white fabric so might as well make it black
                int tint = 255;
                RenderSystem.setShaderColor(1, 1, 1, 1);
                class_4588 vb2 = buffer.getBuffer(RenderUtil.getColoredTextureRenderType(MapDecorationClientManager.LOCATION_MAP_MARKERS));
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (j != 0 || k != 0) {
                            matrixStack.method_22903();
                            matrixStack.method_22904(j * 0.125, k * 0.125, 0.001);

                            RenderUtil.renderSprite(matrixStack, vb2, class_765.field_32767, tint, tint, tint, alpha, sprite);
                            matrixStack.method_22909();
                        }
                    }
                }
            }
            matrixStack.method_22909();
        }
    }


    protected void renderName(T decoration, class_4587 matrixStack, class_4597 buffer, int light) {
        class_327 font = class_310.method_1551().field_1772;
        class_2561 displayName = decoration.getDisplayName();
        float width = font.method_27525(displayName);
        float scale = class_3532.method_15363(25.0F / width, 0.0F, 6.0F / 9.0F);
        matrixStack.method_22903();
        matrixStack.method_22904((0.0F + (float) decoration.getX() / 2.0F + 64.0F - width * scale / 2.0F), (0.0F + (float) decoration.getY() / 2.0F + 64.0F + 4.0F), (double) -0.025F);
        if (CompatHandler.MAP_ATLASES) {
            MapAtlasCompat.scaleDecorationText(matrixStack, width, scale);
        }
        matrixStack.method_22905(scale, scale, 1.0F);
        matrixStack.method_22904(0.0D, 0.0D, -0.1F);
        font.method_30882(displayName, 0.0F, 0.0F, -1, false, matrixStack.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, Integer.MIN_VALUE, light);
        matrixStack.method_22909();
    }


}
