package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Supplier;

//these are what is in json. Each json = a new instance of these Types
public sealed abstract class MLMapDecorationType<D extends MLMapDecoration, M extends MLMapMarker<D>> permits MLJsonMapDecorationType, MLSpecialMapDecorationType {

    //pain
    public static final Codec<MLMapDecorationType<?, ?>> DIRECT_CODEC =
            Codec.lazyInitialized(() -> Codec.either(MLSpecialMapDecorationType.CODEC, MLJsonMapDecorationType.CODEC).xmap(
                    either -> either.map(s -> s, c -> c),
                    type -> {
                        if (type == null) {
                            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
                        }
                        if (type instanceof MLSpecialMapDecorationType<?, ?> c) {
                            return Either.left(c);
                        }
                        return Either.right((MLJsonMapDecorationType) type);
                    }));


    // registry reference codec
    public static final Codec<class_6880<MLMapDecorationType<?, ?>>> CODEC = class_5381.method_29749(MapDataRegistry.REGISTRY_KEY, DIRECT_CODEC);
    // registry reference network codec
    public static final class_9139<class_9129, class_6880<MLMapDecorationType<?, ?>>> STREAM_CODEC = class_9135.method_56383(MapDataRegistry.REGISTRY_KEY);

    private final class_9139<class_9129, D> decorationCodec;
    private final MapCodec<M> markerCodec;

    // hack
    private final Supplier<class_6880<MLMapDecorationType<?, ?>>> builtinHolder = Suppliers.memoize(
            () -> MapDataInternal.hackyGetRegistry().method_47983(this)
    );

    protected MLMapDecorationType(MapCodec<M> markerCodec, class_9139<class_9129, D> decorationCodec) {
        this.decorationCodec = decorationCodec;
        this.markerCodec = markerCodec;
    }


    /**
     * If this marker should be saved to disk as its been grabbed from a world block
     */
    @ApiStatus.Internal
    abstract boolean isFromWorld();

    public abstract class_2960 getCustomFactoryID();

    @Nullable
    public abstract M createMarkerFromWorld(class_1922 reader, class_2338 pos);

    public int getDefaultMapColor() {
        return 1;
    }

    public Optional<class_6885<class_3195>> getAssociatedStructure() {
        return Optional.empty();
    }

    //decoration, not saved, sent to the client
    public class_9139<? super class_9129, D> getDecorationCodec() {
        return decorationCodec;
    }

    //markers. saved and stored in nbt
    public MapCodec<M> getMarkerCodec() {
        return markerCodec;
    }

    protected class_6880<MLMapDecorationType<?, ?>> wrapAsHolder() {
        return builtinHolder.get();
    }
}
