package net.mehvahdjukaar.moonlight.api.misc;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7226;
import net.minecraft.class_7871;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;

public class HolderReference<T> {

    private final class_5321<class_2378<T>> registryKey;
    private final class_5321<T> key;

    private final WeakHashMap<class_7225.class_7874, class_6880<T>> cache = new WeakHashMap<>();

    private static final WeakHashSet<HolderReference<?>> REFERENCES = new WeakHashSet<>();

    @ApiStatus.Internal
    public static void clearCache() {
        REFERENCES.forEach(HolderReference::invalidateCache);
    }

    private void invalidateCache() {
        cache.clear();
    }


    protected HolderReference(class_5321<class_2378<T>> registryKey, class_5321<T> key) {
        this.registryKey = registryKey;
        this.key = key;

        REFERENCES.add(this);
    }

    public static <A> HolderReference<A> of(String id, class_5321<class_2378<A>> registry) {
        return of(class_2960.method_12829(id), registry);
    }

    public static <A> HolderReference<A> of(class_2960 location, class_5321<class_2378<A>> registry) {
        return new HolderReference<>(registry, class_5321.method_29179(registry, location));
    }

    public static <A> HolderReference<A> of(class_5321<A> key) {
        return new HolderReference<>(class_5321.method_29180(key.method_41185()), key);
    }

    public static <A> HolderReference.Opt<A> optional(class_5321<A> key) {
        return new HolderReference.Opt<>(class_5321.method_29180(key.method_41185()), key);
    }

    @Deprecated(forRemoval = true)
    public T getUnsafe() {
        return get(Utils.hackyGetRegistryAccess());
    }

    public T get(class_1297 entity) {
        return get(entity.method_37908());
    }

    public T get(class_1937 level) {
        return get(level.method_30349());
    }

    public T get(class_7225.class_7874 r) {
        return getHolder(r).comp_349();
    }

    @Deprecated(forRemoval = true)
    public class_6880<T> getHolderUnsafe() {
        return getHolder(Utils.hackyGetRegistryAccess());
    }

    public class_6880<T> getHolder(class_1297 entity) {
        return getHolder(entity.method_37908());
    }

    public class_6880<T> getHolder(class_1937 level) {
        return getHolder(level.method_30349());
    }

    public class_6880<T> getHolder(class_7225.class_7874 r) {
        var holder = cache.get(r);
        if (holder != null) return holder;
        var lookupReg = r.method_46759(registryKey);
        var reg = lookupReg.get();
        holder = lookup(reg);
        cache.put(r, holder);
        return holder;
    }

    public class_6880<T> lookup(class_7871<T> lookup) {
        try {
            return lookup.method_46747(key);
        } catch (Exception e) {
            String extra = "";
            if (lookup instanceof class_7225<T> l) {
                extra = ".\nRegistry content was: " + l.method_42017().map(b -> b.method_40237().method_29177()).toList();
            }
            throw new RuntimeException("Failed to get object from registry: " + key +
                    ".\nCalled from " + Thread.currentThread() + ".\n" + extra);
        }
    }

    public String getRegisteredName() {
        return key.method_29177().toString();
    }

    public class_2960 getID() {
        return key.method_29177();
    }

    public class_5321<T> getKey() {
        return key;
    }

    public boolean is(class_2960 location) {
        return registryKey.method_29177().equals(location);
    }

    public boolean is(class_5321<T> resourceKey) {
        return resourceKey == key;
    }

    public boolean is(Predicate<class_5321<T>> predicate) {
        return predicate.test(key);
    }

    public boolean is(class_6880<T> other) {
        return other.method_40230().get() == key;
    }

    @Override
    public String toString() {
        return "DynamicHolder{" + key + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof HolderReference<?> that)) return false;
        return Objects.equals(registryKey, that.registryKey) && Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(registryKey, key);
    }

    public static class Opt<T> extends HolderReference<T> {

        protected Opt(class_5321<class_2378<T>> registryKey, class_5321<T> key) {
            super(registryKey, key);
        }

        public boolean isPresent(class_7225.class_7874 r) {
            return getHolder(r) != null;
        }

        public Optional<class_6880<T>> asOptionalHolder(class_7225.class_7874 r) {
            return Optional.ofNullable(getHolder(r));
        }

        public Optional<T> asOptional(class_7225.class_7874 r) {
            return Optional.ofNullable(get(r));
        }

        @Nullable
        @Override
        public T get(class_7225.class_7874 r) {
            var h = super.getHolder(r);
            return h != null ? h.comp_349() : null;
        }

        @Nullable
        @Override
        public T get(class_1937 level) {
            return super.get(level);
        }

        @Nullable
        @Override
        public T get(class_1297 entity) {
            return super.get(entity);
        }

        @Nullable
        @Override
        public T getUnsafe() {
            return super.getUnsafe();
        }

        @Nullable
        @Override
        public class_6880<T> getHolder(class_7225.class_7874 r) {
            return super.getHolder(r);
        }

        @Nullable
        @Override
        public class_6880<T> getHolder(class_1937 level) {
            return super.getHolder(level);
        }

        @Deprecated(forRemoval = true)
        @Nullable
        @Override
        public class_6880<T> getHolderUnsafe() {
            return super.getHolderUnsafe();
        }

        @Nullable
        @Override
        public class_6880<T> getHolder(class_1297 entity) {
            return super.getHolder(entity);
        }

        @Nullable
        @Override
        public class_6880<T> lookup(class_7871<T> lookup) {
            try {
                return super.lookup(lookup);
            } catch (Exception e) {
                return null;
            }
        }
    }
}

