package net.mehvahdjukaar.moonlight.api.platform.network.fabric;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_8710;
import net.minecraft.class_9129;


public class NetworkHelperImplClient {

    public static <M extends Message> void register(class_8710.class_9155<class_9129, M> messageType) {

        ClientPlayNetworking.registerGlobalReceiver(messageType.comp_2243(),
                (message, context) -> {
                    context.client().execute(() -> {
                        message.handle(new ContextWrapper(context));
                    });
                });
    }

    public record ContextWrapper(ClientPlayNetworking.Context c) implements Message.Context {

        @Override
        public Message.NetworkDir getDirection() {
            return Message.NetworkDir.CLIENT_BOUND;
        }

        @Override
        public class_1657 getPlayer() {
            return c.player();
        }

        @Override
        public void disconnect(class_2561 reason) {
            c.responseSender().disconnect(reason);
        }

        @Override
        public void reply(class_8710 message) {
            c.responseSender().sendPacket(message);
        }
    }

}
