/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.fabric;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class BlockSetInternalImpl {
    private static boolean hasFilledBlockSets = false;
    private static final Map<class_2378<?>, Map<Class<? extends BlockType>, LateBTRegQueue<?, ?>>> QUEUES_OLD = new HashMap();
    private static final Map<class_2378<?>, LateRegQueue<?>> QUEUES = new HashMap();

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    public static <E> void addDynamicRegistration(String modId, Consumer<Registrator<E>> registrationFunction, class_2378<E> registry) {
        LateRegQueue r = QUEUES.computeIfAbsent(registry, b -> new LateRegQueue(registry));
        r.add(registrationFunction);
    }

    @Deprecated
    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, class_2378<E> registry) {
        LateBTRegQueue r = QUEUES_OLD.computeIfAbsent(registry, b -> new LinkedHashMap()).computeIfAbsent(blockType, b -> new LateBTRegQueue(blockType, registry));
        r.add(registrationFunction);
    }

    public static void initializeBlockSets() {
        BlockSetInternal.initializeBlockSets();
        hasFilledBlockSets = true;
    }

    public static void registerDynamicOrdered(List<? extends class_5321<? extends class_2378<?>>> regs) {
        for (class_5321<class_2378<?>> class_53212 : regs) {
            LateRegQueue<?> q2;
            class_2378 registry = (class_2378)class_7923.field_41167.method_29107(class_53212);
            Map<Class<BlockType>, LateBTRegQueue<?, ?>> q = QUEUES_OLD.get(registry);
            if (q != null) {
                for (Map.Entry<Class<BlockType>, LateBTRegQueue<?, ?>> e : q.entrySet()) {
                    e.getValue().registerEntries();
                }
                QUEUES_OLD.remove(registry);
            }
            if ((q2 = QUEUES.get(registry)) != null) {
                q2.registerEntries();
                QUEUES.remove(registry);
            }
            for (Map<Class<BlockType>, LateBTRegQueue<?, ?>> map : QUEUES_OLD.values()) {
                for (Map.Entry<Class<BlockType>, LateBTRegQueue<?, ?>> e : map.entrySet()) {
                    e.getValue().registerEntries();
                }
            }
            QUEUES_OLD.clear();
            for (LateRegQueue lateRegQueue : QUEUES.values()) {
                lateRegQueue.registerEntries();
            }
            QUEUES.clear();
        }
    }

    private static class LateRegQueue<E> {
        final Queue<Consumer<Registrator<E>>> queue = new ArrayDeque<Consumer<Registrator<E>>>();
        final class_2378<E> registry;

        public LateRegQueue(class_2378<E> registry) {
            this.registry = registry;
        }

        public void add(Consumer<Registrator<E>> callback) {
            this.queue.add(callback);
        }

        public void registerEntries() {
            this.queue.forEach(a -> a.accept((n, i) -> class_2378.method_10230(this.registry, (class_2960)n, (Object)i)));
        }
    }

    @Deprecated
    private static class LateBTRegQueue<T extends BlockType, E> {
        final Class<T> blockType;
        final Queue<BlockSetAPI.BlockTypeRegistryCallback<E, T>> queue = new ArrayDeque<BlockSetAPI.BlockTypeRegistryCallback<E, T>>();
        final class_2378<E> registry;

        public LateBTRegQueue(Class<T> blockType, class_2378<E> registry) {
            this.blockType = blockType;
            this.registry = registry;
        }

        public void add(BlockSetAPI.BlockTypeRegistryCallback<E, T> callback) {
            this.queue.add(callback);
        }

        public void registerEntries() {
            this.queue.forEach(a -> a.accept((n, i) -> class_2378.method_10230(this.registry, (class_2960)n, (Object)i), BlockSetAPI.getBlockSet(this.blockType).getValues()));
        }
    }
}

