package net.mehvahdjukaar.moonlight.api.block;


import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

import java.util.List;

public abstract class MimicBlock extends Block {
    protected MimicBlock(Properties properties) {
        super(properties.m_60991_(MimicBlock::hasEmissiveRendering));
    }

    private static boolean hasEmissiveRendering(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        if (blockGetter.m_7702_(pos) instanceof IBlockHolder tile) {
            BlockState mimic = tile.getHeldBlock();
            return mimic.m_60788_(blockGetter, pos);
        }
        return false;
    }


    //THIS IS DANGEROUS
    @Override
    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        if (worldIn.m_7702_(pos) instanceof IBlockHolder tile) {
            BlockState mimicState = tile.getHeldBlock();
            //prevent infinite recursion
            if (!mimicState.m_60795_() && !(mimicState.m_60734_() instanceof MimicBlock))
                return Math.min(super.m_5880_(state, player, worldIn, pos),
                        mimicState.m_60625_(player, worldIn, pos));
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    //might cause lag when breaking?
//@Override
    @PlatformOnly(PlatformOnly.FORGE)
    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        if (world.m_7702_(pos) instanceof IBlockHolder tile) {
            BlockState mimicState = tile.getHeldBlock();
            if (!mimicState.m_60795_()) return mimicState.m_60827_();
        }
        return super.m_49962_(state);
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List<ItemStack> drops = super.m_49635_(state, builder);
        if (builder.m_287159_(LootContextParams.f_81462_) instanceof IBlockHolder tile) {
            //checks again if the content itself can be mined
            BlockState heldState = tile.getHeldBlock();
            if (builder.m_287159_(LootContextParams.f_81455_) instanceof ServerPlayer player) {
                if (!ForgeHelper.canHarvestBlock(heldState, builder.m_287258_(),
                        BlockPos.m_274446_(builder.m_287261_(LootContextParams.f_81460_)), player)) {
                    return drops;
                }
            }
            List<ItemStack> newDrops = heldState.m_287290_(builder);
            drops.addAll(newDrops);
        }
        return drops;
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    //@Override
    @PlatformOnly(PlatformOnly.FORGE)
    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        if (world.m_7702_(pos) instanceof IBlockHolder tile) {
            BlockState mimicState = tile.getHeldBlock();
            if (!mimicState.m_60795_() && !(mimicState.m_60734_() instanceof MimicBlock)) {
                return Math.max(ForgeHelper.getExplosionResistance(mimicState, (Level) world, pos, explosion),
                        state.m_60734_().m_7325_());
            }
        }
        return 2;
    }

    @Override
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        if (level.m_7702_(pos) instanceof IBlockHolder tile) {
            BlockState mimic = tile.getHeldBlock();
            return mimic.m_60734_().m_7397_(level, pos, state);
        }
        return super.m_7397_(level, pos, state);
    }


}
