package net.mehvahdjukaar.moonlight.api.client.util;

import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class RotHlpr {
    //TODO: merge with math helper
    //dont modify these pls. these are mutable unforunately posestack doesnt accept Quaternionfc
    public static final Quaternionf Y180 = Axis.f_252436_.m_252977_(180);
    public static final Quaternionf Y90 = Axis.f_252436_.m_252977_(90);
    public static final Quaternionf Y45 = Axis.f_252436_.m_252977_(45);
    public static final Quaternionf YN45 = Axis.f_252436_.m_252977_(-45);
    public static final Quaternionf YN90 = Axis.f_252436_.m_252977_(-90);
    public static final Quaternionf YN180 = Axis.f_252436_.m_252977_(-180);

    public static final Quaternionf X180 = Axis.f_252529_.m_252977_(180);
    public static final Quaternionf X90 = Axis.f_252529_.m_252977_(90);
    public static final Quaternionf X22 = Axis.f_252529_.m_252977_(22.5f);
    public static final Quaternionf XN22 = Axis.f_252529_.m_252977_(-22.5f);
    public static final Quaternionf XN90 = Axis.f_252529_.m_252977_(-90);
    public static final Quaternionf XN180 = Axis.f_252529_.m_252977_(-180);

    public static final Quaternionf Z180 = Axis.f_252403_.m_252977_(180);
    public static final Quaternionf Z135 = Axis.f_252403_.m_252977_(135);
    public static final Quaternionf Z90 = Axis.f_252403_.m_252977_(90);
    public static final Quaternionf ZN45 = Axis.f_252403_.m_252977_(-45);
    public static final Quaternionf ZN90 = Axis.f_252403_.m_252977_(-90);
    public static final Quaternionf ZN180 = Axis.f_252403_.m_252977_(-180);

    private static final Map<Direction, Quaternionf> DIR2ROT = Maps.newEnumMap(Arrays.stream(Direction.values())
            .collect(Collectors.toMap(Functions.identity(), d -> d.m_122424_().m_253075_().mul(XN90))));

    private static final Map<Integer, Quaternionf> YAW2ROT = Arrays.stream(Direction.values()).filter(d -> d.m_122434_() != Direction.Axis.Y)
            .map(d -> (int) -d.m_122435_()).collect(Collectors.toMap(Functions.identity(), y -> Axis.f_252436_.m_252977_(y)));

    //relative to north facing
    public static Quaternionf rot(Direction dir) {
        return DIR2ROT.get(dir);
    }

    private static final Quaternionf def = Axis.f_252436_.m_252977_(0);

    public static Quaternionf rot(int rot) {
        return YAW2ROT.getOrDefault(rot, def);
    }

    @Deprecated(forRemoval = true)
    public static Vector3f rotateVertexOnCenterBy(float x, float y, float z, Matrix4f pTransform) {
        Vector3f v = new Vector3f(x, y, z);
        rotateVertexBy(v, new Vector3f(0.5F, 0.5F, 0.5F), pTransform);
        return v;
    }

    @Deprecated(forRemoval = true)
    public static void rotateVertexBy(Vector3f pPos, Vector3f pOrigin, Matrix4f pTransform) {
        Vector4f vector4f = new Vector4f(pPos.x() - pOrigin.x(), pPos.y() - pOrigin.y(), pPos.z() - pOrigin.z(), 1.0F);
        vector4f.mul(pTransform);
        pPos.set(vector4f.x() + pOrigin.x(), vector4f.y() + pOrigin.y(), vector4f.z() + pOrigin.z());
    }

    @Deprecated(forRemoval = true)
    public static Direction rotateDirection(Direction direction, Matrix4f transform) {
        var d = direction.m_122436_();
        var normal = new Vector3f(d.m_123341_(), d.m_123342_(), d.m_123343_());
        RotHlpr.rotateVertexBy(normal, new Vector3f(), transform);
        return Direction.m_122372_(normal.x(), normal.y(), normal.z());
    }

}