package net.mehvahdjukaar.moonlight.api.client.util.forge;


import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;

public class RenderUtilImpl {


    public static void renderBlock(BakedModel model, long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state,
                                   Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        //same as ForgeHooksClient.renderPistonMovedBlocks (what pistons use)
        for (var renderType : model.getRenderTypes(state, RandomSource.m_216335_(seed), ModelData.EMPTY))
        {
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderTypeHelper.getMovingBlockRenderType(renderType));
            dispatcher.m_110937_().tesselateBlock(level, model, state, pos, poseStack, vertexConsumer, false,
                    RandomSource.m_216327_(), state.m_60726_(pos), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        }
    }

    public static void renderGuiItem(BakedModel model, ItemStack stack, ItemRenderer renderer, int combinedLight, int pCombinedOverlay,
                                     PoseStack poseStack, MultiBufferSource.BufferSource buffer, boolean flatItem) {

        poseStack.m_85836_();

        poseStack.m_85837_(-0.5D, -0.5D, -0.5D);

        if (!model.m_7521_() && (!stack.m_150930_(Items.f_42713_) || flatItem)) {
            boolean fabulous = true;

            for (var m : model.getRenderPasses(stack, fabulous)) {
                for (var renderType : m.getRenderTypes(stack, fabulous)) {

                    VertexConsumer vertexconsumer;
                    if (stack.m_150930_(Items.f_42522_) && stack.m_41790_()) {
                        poseStack.m_85836_();
                        PoseStack.Pose pose = poseStack.m_85850_();
                        pose.m_252922_().scale(0.5F);

                        vertexconsumer = ItemRenderer.m_115207_(buffer, renderType, pose);

                        poseStack.m_85849_();
                    } else {
                        vertexconsumer = ItemRenderer.m_115222_(buffer, renderType, true, stack.m_41790_());
                    }

                    renderer.m_115189_(model, stack, combinedLight, pCombinedOverlay, poseStack, vertexconsumer);
                }
            }
        } else {
            IClientItemExtensions.of(stack).getCustomRenderer().m_108829_(stack, ItemDisplayContext.GUI,
                    poseStack, buffer, combinedLight, pCombinedOverlay);
        }

        poseStack.m_85849_();
    }

    public static BakedModel handleCameraTransforms(BakedModel model, PoseStack poseStack, ItemDisplayContext transform) {
        return ForgeHooksClient.handleCameraTransforms(poseStack, model, transform, false);
    }


}