package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

//hacky registered item that handles placing placeable stuff
public final class BlockPlacerItem extends BlockItem {

    public static BlockPlacerItem get() {
        return MoonlightRegistry.BLOCK_PLACER.get();
    }

    private FoodProperties mimicFood;
    private Block mimicBlock;
    private SoundType overrideSound;

    public BlockPlacerItem(Block pBlock, Properties pProperties) {
        super(pBlock, pProperties);
    }

    @Override
    public void m_6192_(Map<Block, Item> pBlockToItemMap, Item pItem) {
        AdditionalItemPlacementsAPI.onRegistryCallback(pBlockToItemMap);
    }


    @Nullable
    public BlockState mimicGetPlacementState(BlockPlaceContext pContext, Block toPlace) {
        this.mimicBlock = toPlace;
        var r = m_5965_(pContext);
        this.mimicBlock = null;
        return r;
    }

    public InteractionResult mimicUseOn(UseOnContext pContext, Block toPlace, @Nullable FoodProperties foodProperties) {
        this.mimicFood = foodProperties;
        this.mimicBlock = toPlace;
        var r = super.m_6225_(pContext);
        this.mimicFood = null;
        this.mimicBlock = null;
        return r;
    }

    public InteractionResult mimicPlace(BlockPlaceContext pContext, Block toPlace, @Nullable SoundType overrideSound) {
        this.overrideSound = overrideSound;
        this.mimicBlock = toPlace;
        var r = super.m_40576_(pContext);
        this.overrideSound = null;
        this.mimicBlock = null;
        return r;
    }

    @Override
    public Block m_40614_() {
        if (this.mimicBlock != null) return mimicBlock;
        return super.m_40614_();
    }

    @Nullable
    @Override
    public FoodProperties m_41473_() {
        return mimicFood;
    }

    @Override
    public boolean m_41472_() {
        return mimicFood != null;
    }

    @Override
    protected SoundEvent m_40587_(BlockState pState) {
        if (this.overrideSound != null) return this.overrideSound.m_56777_();
        return super.m_40587_(pState);
    }

    @Override
    public boolean m_40610_(BlockPlaceContext pContext, BlockState pState) {
        this.mimicBlock = pState.m_60734_();
        boolean r = super.m_40610_(pContext, pState);
        this.mimicBlock = null;
        return r;
    }

    @Override
    public String m_5524_() {
        return "x";
    }
}
