package net.mehvahdjukaar.moonlight.api.resources.pack;

import ;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;

import java.io.ByteArrayInputStream;

public class DynamicDataPack extends DynamicResourcePack {

    public DynamicDataPack(ResourceLocation name, Pack.Position position, boolean fixed, boolean hidden) {
        super(name, PackType.SERVER_DATA, position, fixed, hidden);
    }

    public DynamicDataPack(ResourceLocation name) {
        super(name, PackType.SERVER_DATA);
    }


    @Deprecated(forRemoval = true)
    @Override
    public void addTag(SimpleTagBuilder builder, ResourceKey<?> type) {

        ResourceLocation tagId = builder.getId();
        String tagPath = type.m_135782_().m_135815_();
        if (tagPath.equals("block") || tagPath.equals("entity_type") || tagPath.equals("item") || tagPath.equals("fluid")) tagPath = tagPath + "s";
        ResourceLocation loc = ResType.TAGS.getPath(new ResourceLocation(tagId.m_135827_(),
                tagPath + "/" + tagId.m_135815_()));
        //merge tags
        if (this.resources.containsKey(loc)) {
            var r = resources.get(loc);
            try (var stream = new ByteArrayInputStream(r)) {
                var oldTag = RPUtils.deserializeJson(stream);
                builder.addFromJson(oldTag);
            } catch (Exception ignored) {
            }
        }
        JsonElement json = builder.serializeToJson();
        this.addJson(loc, json, ResType.GENERIC);
    }

    /**
     * Adds a simple loot table that only drops the block itself
     *
     * @param block block to be dropped
     */
    @Deprecated(forRemoval = true)
    public void addSimpleBlockLootTable(Block block) {
        this.addLootTable(block, createSingleItemTable(block)
                        .m_79165_(LootContextParamSets.f_81421_));
    }

    @Deprecated(forRemoval = true)
    public void addLootTable(Block block, LootTable.Builder table){
        this.addLootTable(block.m_60589_(), table.m_79167_());
    }

    @Deprecated(forRemoval = true)
    public void addLootTable(ResourceLocation id, LootTable table){
        this.addJson(id, LootDataType.f_278413_.m_278857_().toJsonTree(table), ResType.LOOT_TABLES);
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike itemLike) {
        return LootTable.m_79147_()
                .m_79161_(
                        LootPool.m_79043_()
                                .m_165133_(ConstantValue.m_165692_(1.0F))
                                .m_79076_(LootItem.m_79579_(itemLike)).m_79073_());
    }

    @Deprecated(forRemoval = true)
    public void addRecipe(FinishedRecipe recipe) {
        this.addJson(recipe.m_6445_(), recipe.m_125966_(), ResType.RECIPES);
        ResourceLocation advancementId = recipe.m_6448_();
        if (advancementId != null) {
            this.addJson(recipe.m_6448_(), recipe.m_5860_(), ResType.ADVANCEMENTS);
        }
    }

    @Deprecated(forRemoval = true)
    public void addRecipeNoAdvancement(FinishedRecipe recipe) {
        this.addJson(recipe.m_6445_(), recipe.m_125966_(), ResType.RECIPES);
    }

}
