package net.mehvahdjukaar.moonlight.api.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static net.minecraft.world.item.alchemy.PotionUtils.m_43561_;
import static net.minecraft.world.item.alchemy.PotionUtils.m_43564_;

public class PotionNBTHelper {
    private static final MutableComponent EMPTY = (Component.m_237115_("effect.none")).m_130940_(ChatFormatting.GRAY);

    //I need this because I'm using block entity tag, so I can't give PotionUtil methods an itemStack directly
    public static void addPotionTooltip(@Nullable CompoundTag com, List<Component> tooltip, float durationFactor) {
        List<MobEffectInstance> list = m_43566_(com);
        List<Pair<Attribute, AttributeModifier>> list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.add(EMPTY);
        } else {
            for (MobEffectInstance effectInstance : list) {
                MutableComponent translatable = Component.m_237115_(effectInstance.m_19576_());
                MobEffect effect = effectInstance.m_19544_();
                Map<Attribute, AttributeModifier> map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry<Attribute, AttributeModifier> entry : map.entrySet()) {
                        AttributeModifier attributemodifier = entry.getValue();
                        AttributeModifier modifier = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectInstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair<>(entry.getKey(), modifier));
                    }
                }

                if (effectInstance.m_19564_() > 0) {
                    translatable = Component.m_237110_("potion.withAmplifier", translatable, Component.m_237115_("potion.potency." + effectInstance.m_19564_()));
                }

                if (effectInstance.m_19557_() > 20) {
                    translatable = Component.m_237110_("potion.withDuration", translatable, MobEffectUtil.m_267641_(effectInstance, durationFactor));
                }

                tooltip.add(translatable.m_130940_(effect.m_19483_().m_19497_()));
            }
        }

        if (!list1.isEmpty()) {
            tooltip.add(CommonComponents.f_237098_);
            tooltip.add(Component.m_237115_("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));

            for (Pair<Attribute, AttributeModifier> pair : list1) {
                AttributeModifier modifier = pair.getSecond();
                double d0 = modifier.m_22218_();
                double d1;
                if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) {
                    d1 = modifier.m_22218_();
                } else {
                    d1 = modifier.m_22218_() * 100.0D;
                }

                if (d0 > 0.0D) {
                    tooltip.add(Component.m_237110_("attribute.modifier.plus." + modifier.m_22217_().m_22235_(), ItemStack.f_41584_.format(d1), Component.m_237115_(pair.getFirst().m_22087_())).m_130940_(ChatFormatting.BLUE));
                } else if (d0 < 0.0D) {
                    d1 = d1 * -1.0D;
                    tooltip.add(Component.m_237110_("attribute.modifier.take." + modifier.m_22217_().m_22235_(), ItemStack.f_41584_.format(d1), Component.m_237115_(pair.getFirst().m_22087_())).m_130940_(ChatFormatting.RED));
                }
            }
        }

    }

    public static int getColorFromNBT(@Nullable CompoundTag com) {
        if (com != null && com.m_128425_("CustomPotionColor", 99)) {
            return com.m_128451_("CustomPotionColor");
        } else {
            return m_43564_(m_43566_(com));
        }
    }

    public enum Type {
        REGULAR,
        SPLASH,
        LINGERING;

        static final Map<String, Type> BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(
                Enum::name, i -> i));

        public ItemStack getDefaultItem() {
            return (switch (this) {
                case REGULAR -> Items.f_42589_;
                case LINGERING -> Items.f_42739_;
                case SPLASH -> Items.f_42736_;
            }).m_7968_();
        }

        public void applyToTag(CompoundTag tag){
            tag.m_128359_(POTION_TYPE_KEY, this.name());
        }
    }

    public static final String POTION_TYPE_KEY = "Bottle";

    @Nullable
    public static PotionNBTHelper.Type getPotionType(CompoundTag tag) {
        if (!tag.m_128441_(POTION_TYPE_KEY)) return null;
        String type = tag.m_128461_(POTION_TYPE_KEY);
        return Type.BY_NAME.get(type);
    }

    @Nullable
    public static PotionNBTHelper.Type getPotionType(Item potionItem) {
        if (potionItem instanceof SplashPotionItem) return Type.SPLASH;
        else if (potionItem instanceof LingeringPotionItem) return Type.LINGERING;
        else if (potionItem instanceof PotionItem) return Type.REGULAR;
        return null;
    }

}
