package net.mehvahdjukaar.moonlight.core;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.misc.EventCalled;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynResourceGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;

@ApiStatus.Internal
public class MoonlightClient {

    private static final ThreadLocal<Boolean> MAP_MIPMAP = ThreadLocal.withInitial(() -> false);
    private static MergedDynamicTexturePack mergedDynamicPack;

    public static void initClient() {
        ClientHelper.addShaderRegistration(MoonlightClient::registerShaders);
        ClientHelper.addClientReloadListener(SoftFluidColors::new, Moonlight.res("soft_fluids"));
        ClientHelper.addClientReloadListener(MapDecorationClientManager::new, Moonlight.res("map_markers"));
        ClientConfigs.init();
        var gen = new Gen();
        gen.register();
    }


    public static DynamicTexturePack maybeMergePack(DynamicTexturePack pack) {
        if (!ClientConfigs.MERGE_PACKS.get()) return pack;
        if (mergedDynamicPack == null) {
            mergedDynamicPack = new MergedDynamicTexturePack() {
            };
        }
        Set<String> nameSpaces = pack.m_5698_(pack.getPackType());
        for (var n : nameSpaces) mergedDynamicPack.addNamespaces(n);
        mergedDynamicPack.mods++;
        return mergedDynamicPack;
    }

    public static boolean isClientThread() {
        return Minecraft.m_91087_().m_18695_();
    }

    public static void setupClient() {
        var e = ExtraModelData.EMPTY;
        //classloader on main thread to prevent possible race condition BS
    }

    private static class MergedDynamicTexturePack extends DynamicTexturePack {
        int mods = 0;

        public MergedDynamicTexturePack() {
            super(Moonlight.res("mods_dynamic_assets"));
        }

        @Override
        public Component makeDescription() {
            return Component.m_237113_("Dynamic resources for " + mods + (mods == 1 ? " mod" : " mods"));
        }
    }

    @EventCalled
    public static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(Moonlight.res("particle_translucent"), DefaultVertexFormat.f_85817_,
                MLRenderTypes.PARTICLE_TRANSLUCENT_SHADER::assign);
        event.register(Moonlight.res("text_alpha_color"), DefaultVertexFormat.f_85820_,
                MLRenderTypes.TEXT_COLOR_SHADER::assign);


    }

    @EventCalled
    public static void afterTextureReload() {
        DynResourceGenerator.clearAfterReload(PackType.CLIENT_RESOURCES);
    }

    public static void setMipMap(boolean b) {
        if (ClientConfigs.MAPS_MIPMAP.get() == 0) {
            b = false;
        }
        MAP_MIPMAP.set(b);
    }

    public static boolean isMapMipMap() {
        return MAP_MIPMAP.get();
    }


    private static class Gen extends DynClientResourcesGenerator {
        public Gen() {
            super(new DynamicTexturePack(Moonlight.res("generated_pack")));
            this.dynamicPack.addNamespaces("minecraft");
        }

        @Override
        public Logger getLogger() {
            return Moonlight.LOGGER;
        }

        @Override
        public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
            fixShade = ClientConfigs.FIX_SHADE.get();
            revertFixedShade();
            if (fixShade != ClientConfigs.ShadeFix.FALSE) {
                applyFixedShade();

                executor.accept((manager, sink) -> {

                    sink.addBytes(new ResourceLocation("shaders/include/light.glsl"),
                            ("""
                                    #version 150
                                    
                                    #define MINECRAFT_LIGHT_POWER   (0.6)
                                    #define MINECRAFT_LIGHT_POWER_FIXED   (0.5)
                                    #define MINECRAFT_AMBIENT_LIGHT (0.4)
                                    #define MINECRAFT_AMBIENT_LIGHT_FIXED (0.5)
                                    
                                    vec4 minecraft_mix_light(vec3 lightDir0, vec3 lightDir1, vec3 normal, vec4 color) {
                                        lightDir0 = normalize(lightDir0);
                                        lightDir1 = normalize(lightDir1);
                                        float light0 = max(0.0, dot(lightDir0, normal));
                                        float light1 = max(0.0, dot(lightDir1, normal));
                                    
                                        float dotP = dot(lightDir0, lightDir1);
                                        bool isFixed = dotP > 0.20 && dotP < 0.205;
                                        float lightPow = isFixed ? MINECRAFT_LIGHT_POWER_FIXED : MINECRAFT_LIGHT_POWER;
                                        float ambientLight = isFixed ? MINECRAFT_AMBIENT_LIGHT_FIXED : MINECRAFT_AMBIENT_LIGHT;
                                    
                                        float lightAccum = min(1.0, (light0 + light1) * lightPow + ambientLight);
                                        return vec4(color.rgb * lightAccum, color.a);
                                    }
                                    
                                    vec4 minecraft_sample_lightmap(sampler2D lightMap, ivec2 uv) {
                                        return texture(lightMap, clamp(uv / 256.0, vec2(0.5 / 16.0), vec2(15.5 / 16.0)));
                                    }""").getBytes()

                            , ResType.GENERIC);
                });
            }
        }
    }

    private static ClientConfigs.ShadeFix fixShade = ClientConfigs.ShadeFix.FALSE;

    public static void beforeRenderGui() {
        if (fixShade == ClientConfigs.ShadeFix.NO_GUI) {
            revertFixedShade();
        }
    }

    public static void afterRenderGui() {
        if (fixShade == ClientConfigs.ShadeFix.NO_GUI) {
            applyFixedShade();
        }
    }

    private static void revertFixedShade() {
        if (oldL0 != null) {
            Lighting.f_84919_ = oldL0;
            Lighting.f_84920_ = oldL1;
            Lighting.f_84921_ = oldL0n;
            Lighting.f_84922_ = oldL1n;
            oldL0 = null;
            oldL1 = null;
            oldL0n = null;
            oldL1n = null;
        }
    }

    private static void applyFixedShade() {
        if (oldL0 == null) {
            oldL0 = Lighting.f_84919_;
            oldL1 = Lighting.f_84920_;
            oldL0n = Lighting.f_84921_;
            oldL1n = Lighting.f_84922_;
        }
        Lighting.f_84919_ = NEW_L_0;
        Lighting.f_84920_ = NEW_L_1;
        Lighting.f_84921_ = NEW_L_0;
        Lighting.f_84922_ = NEW_L_1;
    }


    private static Vector3f oldL0 = null;
    private static Vector3f oldL1 = null;

    private static Vector3f oldL0n = null;
    private static Vector3f oldL1n = null;

    // such neat numbers. These give exactly the same shade that block use (1, 0.8, 0.6, 0.5)
    private static final Vector3f NEW_L_0 = new Vector3f(0.2f, 7 / 9f, -0.6f).normalize();
    private static final Vector3f NEW_L_1 = new Vector3f(-0.2f, 7 / 9f, 0.6f).normalize();


}
