package net.mehvahdjukaar.moonlight.core.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.mehvahdjukaar.moonlight.api.client.CoreShaderContainer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL13;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

import static com.mojang.blaze3d.vertex.DefaultVertexFormat.f_85813_;

public class MLRenderTypes extends RenderType {

    public static CoreShaderContainer TEXT_COLOR_SHADER = new CoreShaderContainer(GameRenderer::m_172820_);
    public static CoreShaderContainer PARTICLE_TRANSLUCENT_SHADER = new CoreShaderContainer(GameRenderer::m_172829_);


    public static final Function<ResourceLocation, RenderType> COLOR_TEXT = Util.m_143827_((p) ->
    {
        CompositeState compositeState = CompositeState.m_110628_()
                .m_173292_(new ShaderStateShard(TEXT_COLOR_SHADER))
                .m_173290_(new TextureStateShard(p,
                        false, true))
                .m_110685_(f_110139_)
                .m_110671_(f_110152_)
                .m_110691_(false);
        return m_173215_("moonlight_text_color_mipped",
                DefaultVertexFormat.f_85820_,
                VertexFormat.Mode.QUADS, 256, false, true,
                compositeState);
    });

    public static final Function<ResourceLocation, RenderType> TEXT_MIP = Util.m_143827_((p) ->
    {
        CompositeState compositeState = CompositeState.m_110628_()
                .m_173292_(f_173086_)
                .m_173290_(new TextureStateShard(p, false, true))
                .m_110685_(f_110139_)
                .m_110671_(f_110152_)
                .m_110691_(false);
        return m_173215_("moonlight_text_mipped",
                DefaultVertexFormat.f_85820_,
                VertexFormat.Mode.QUADS, 256, false, true,
                compositeState);
    });

    public static final Function<ResourceLocation, RenderType> ENTITY_SOLID_MIP = Util.m_143827_((resourceLocation) -> {
        CompositeState compositeState = RenderType.CompositeState.m_110628_()
                .m_173292_(f_173112_)
                .m_173290_(new RenderStateShard.TextureStateShard(resourceLocation, false, true))
                .m_110685_(f_110134_)
                .m_110671_(f_110152_)
                .m_110677_(f_110154_)
                .m_110691_(true);
        return m_173215_("moonlight_entity_solid_mipped", DefaultVertexFormat.f_85812_,
                VertexFormat.Mode.QUADS,
                256, true, false,
                compositeState);
    });

    public static final Function<ResourceLocation, RenderType> ENTITY_CUTOUT_MIP = Util.m_143827_(resourceLocation -> {
        CompositeState compositeState = CompositeState.m_110628_()
                .m_173292_(f_173113_)
                .m_173290_(new RenderStateShard.TextureStateShard(resourceLocation, false, true))
                .m_110685_(f_110134_)
                .m_110671_(f_110152_)
                .m_110677_(f_110154_)
                .m_110691_(true);
        return RenderType.m_173215_("moonlight_entity_cutout_mipped",
                DefaultVertexFormat.f_85812_,
                VertexFormat.Mode.QUADS, 256, true, false,
                compositeState);
    });


    public static final ParticleRenderType PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE = new ParticleRenderType() {
        @Override
        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
            RenderSystem.activeTexture(GL13.GL_TEXTURE2);
            RenderSystem.activeTexture(GL13.GL_TEXTURE0);
            //because of custom render type fuckery...

            RenderSystem.setShader(PARTICLE_TRANSLUCENT_SHADER::get);
            RenderSystem.depthMask(false);
            RenderSystem.setShaderTexture(0, TextureAtlas.f_118260_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE);
            builder.m_166779_(VertexFormat.Mode.QUADS, f_85813_);
        }

        @Override
        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "PARTICLE_SHEET_ADDITIVE_TRANSLUCENT";
        }
    };


    public MLRenderTypes(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
        super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
    }
}
