package net.mehvahdjukaar.moonlight.core.criteria_triggers;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.advancements.critereon.*;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GrindItemTrigger extends SimpleCriterionTrigger<GrindItemTrigger.Instance> {
    private static final ResourceLocation ID = Moonlight.res("grind_item");

    @Override
    public @NotNull ResourceLocation m_7295_() {
        return ID;
    }

    @Override
    public Instance m_7214_(JsonObject json, ContextAwarePredicate predicate, DeserializationContext deserializationContext) {
        ItemPredicate itempredicate = ItemPredicate.m_45051_(json.get("item"));
        return new Instance(predicate, itempredicate);
    }

    public void trigger(ServerPlayer playerEntity, ItemStack stack) {
        this.m_66234_(playerEntity, (instance) -> instance.matches(stack));
    }

    protected static class Instance extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;

        public Instance(ContextAwarePredicate contextAwarePredicate, ItemPredicate item) {
            super(GrindItemTrigger.ID, contextAwarePredicate);
            this.item = item;
        }


        public boolean matches(ItemStack stack) {
            return this.item.m_45049_(stack);
        }

        @Override
        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject jsonobject = super.m_7683_(serializer);
            jsonobject.add("item", this.item.m_45048_());
            return jsonobject;
        }
    }
}
