package net.mehvahdjukaar.moonlight.core.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.Heightmap.Types;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

import java.util.List;

public class CaveFilter extends PlacementFilter {

    public static final Codec<CaveFilter> CODEC =
            RecordCodecBuilder.create((instance) -> instance.group(
                            Heightmap.Types.f_64274_.listOf().fieldOf("heightmaps").forGetter((p) -> p.belowHeightMaps),
                            Codec.BOOL.fieldOf("below_sea_level").forGetter(p -> p.belowSeaLevel)
                    )
                    .apply(instance, CaveFilter::new));

    public static class Type implements PlacementModifierType<CaveFilter> {
        @Override
        public Codec<CaveFilter> m_191869_() {
            return CODEC;
        }
    }

    private final List<Heightmap.Types> belowHeightMaps;
    private final Boolean belowSeaLevel;

    private CaveFilter(List<Heightmap.Types> types, Boolean belowSeaLevel) {
        this.belowHeightMaps = types;
        this.belowSeaLevel = belowSeaLevel;
    }


    @Override
    protected boolean m_213917_(PlacementContext context, RandomSource random, BlockPos pos) {
        if (context.m_191831_().m_7726_() instanceof ServerChunkCache serverChunkCache) {
            int y = pos.m_123342_();
            if(belowSeaLevel) {
                int sea = serverChunkCache.m_8481_().m_6337_();
                //below sea level
                if (y > sea) return false;
            }
            for (var h : belowHeightMaps) {
                int k = context.m_191824_(h, pos.m_123341_(), pos.m_123343_());
                if (y > k) return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public PlacementModifierType<?> m_183327_() {
        return MoonlightRegistry.CAVE_MODIFIER.get();
    }


}