package net.mehvahdjukaar.moonlight.core.mixins;

import ;
import io.netty.buffer.Unpooled;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Collection;
import java.util.Map;

//I hope this won't break with mods. We need this as all data needs to be received at the same time
@Mixin(ClientboundMapItemDataPacket.class)
public class MapItemDataPacketMixin implements IMapDataPacketExtension {

    @Shadow
    @Final
    @Nullable
    private MapItemSavedData.MapPatch colorPatch;
    @Shadow
    @Final
    private int mapId;
    @Unique
    private CustomMapDecoration[] moonlight$customDecorations = null;
    @Unique
    private CompoundTag moonlight$customData = null;
    @Unique
    private int moonlight$mapCenterX = 0;
    @Unique
    private int moonlight$mapCenterZ = 0;
    @Unique
    private ResourceLocation moonlight$dimension = Level.f_46428_.m_135782_();

    //new constructor expansion
    @Inject(method = "<init>(IBZLjava/util/Collection;Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData$MapPatch;)V",
            at = @At("RETURN"))
    private void addExtraCenterAndDimension(int mapId, byte b, boolean bl, Collection collection, MapItemSavedData.MapPatch mapPatch, CallbackInfo ci) {
        var level = PlatHelper.getCurrentServer().m_129880_(Level.f_46428_);
        if (level != null) {
            MapItemSavedData data = Moonlight.getMapDataFromKnownKeys(level, mapId);
            if (data != null) {
                this.moonlight$mapCenterX = data.f_256718_;
                this.moonlight$mapCenterZ = data.f_256789_;
                this.moonlight$dimension = data.f_77887_.m_135782_();
            }
        }
    }


    @Inject(method = "<init>(Lnet/minecraft/network/FriendlyByteBuf;)V",
            at = @At("RETURN"))
    private void readExtraData(FriendlyByteBuf buf, CallbackInfo ci) {
        // we always need to send enough data to create the correct map type because we don't know if client has it
        // again velocity BS
        if (!buf.isReadable()) {
            Moonlight.warnInvalidServer();
            return;
        }

        if (buf.readBoolean()) {
            moonlight$dimension = buf.m_130281_();
            moonlight$mapCenterX = buf.m_130242_();
            moonlight$mapCenterZ = buf.m_130242_();
        }
        if (buf.readBoolean()) {
            this.moonlight$customDecorations = new CustomMapDecoration[buf.m_130242_()];
            for (int m = 0; m < moonlight$customDecorations.length; ++m) {
                MapDecorationType<?, ?> type = MapDataInternal.get(buf.m_130281_());
                if (type != null) {
                    moonlight$customDecorations[m] = type.loadDecorationFromBuffer(buf);
                }
            }
        }
        if (buf.readBoolean()) {
            //TODO: I really could have merged the 2 systems
            this.moonlight$customData = buf.m_130260_(); //readCompressedNbt(buf);
        }
    }

    @Inject(method = "write", at = @At("RETURN"))
    private void writeExtraData(FriendlyByteBuf buf, CallbackInfo ci) {
        buf.writeBoolean(moonlight$dimension != null);
        if (moonlight$dimension != null) {
            buf.m_130085_(moonlight$dimension);
            buf.m_130130_(moonlight$mapCenterX);
            buf.m_130130_(moonlight$mapCenterZ);
        }

        buf.writeBoolean(moonlight$customDecorations != null);
        if (moonlight$customDecorations != null) {
            buf.m_130130_(moonlight$customDecorations.length);

            for (CustomMapDecoration decoration : moonlight$customDecorations) {
                buf.m_130085_(Utils.getID(decoration.getType()));
                decoration.saveToBuffer(buf);
            }
        }

        buf.writeBoolean(moonlight$customData != null);
        if (moonlight$customData != null) {
            buf.m_130079_(moonlight$customData);
            // writeCompressedNbt(buf, moonlight$customData);
        }
    }

    @Override
    public void moonlight$sendCustomDecorations(Collection<CustomMapDecoration> decorations) {

        //packet will be passed to client no decoding. if we are on an integrated server we need to create new objects
        if (PlatHelper.getPhysicalSide().isClient()) {
            var buffer = new FriendlyByteBuf(Unpooled.buffer());
            decorations = decorations.stream().map(e -> {
                e.saveToBuffer(buffer);
                CustomMapDecoration d = e.getType().loadDecorationFromBuffer(buffer);
                return d;
            }).toList();
        }
        moonlight$customDecorations = decorations.toArray(CustomMapDecoration[]::new);
    }

    @Override
    public void moonlight$sendCustomMapDataTag(CompoundTag dataTag) {
        moonlight$customData = dataTag;
    }

    @Override
    public CompoundTag moonlight$getCustomMapDataTag() {
        return moonlight$customData;
    }

    @Override
    public MapItemSavedData.MapPatch moonlight$getColorPatch() {
        return colorPatch;
    }

    @Override
    public ResourceKey<Level> moonlight$getDimension() {
        return ResourceKey.m_135785_(Registries.f_256858_, moonlight$dimension);
    }


    @Inject(method = "applyToMap", at = @At("HEAD"))
    private void handleExtraData(MapItemSavedData mapData, CallbackInfo ci) {
        var serverDeco = this.moonlight$customDecorations;
        var serverData = this.moonlight$customData;

        mapData.f_256718_ = this.moonlight$mapCenterX;
        mapData.f_256789_ = this.moonlight$mapCenterZ;
        mapData.f_77887_ = this.moonlight$getDimension();


        if (mapData instanceof ExpandedMapData ed) {
            Map<String, CustomMapDecoration> decorations = ed.getCustomDecorations();


            //mapData = MapItemSavedData.createForClient(message.scale, message.locked, Minecraft.getInstance().level.dimension());
            //Minecraft.getInstance().level.setMapData(string, mapData);

            if (serverDeco != null) {
                decorations.clear();
                int i;
                for (i = 0; i < serverDeco.length; ++i) {
                    CustomMapDecoration customDecoration = serverDeco[i];
                    if (customDecoration != null) decorations.put("icon-" + i, customDecoration);
                    else {
                        Moonlight.LOGGER.warn("Failed to load custom map decoration, skipping");
                    }
                }

            }
            if (serverData != null) {
                var customData = ed.getCustomData();
                for (var v : customData.values()) {
                    v.loadUpdateTag(this.moonlight$customData);
                }
            }

            //adds dynamic todo use deco instead
            // aaa not optimal but needed for player like behavior
            // update immediately all the times
            for (MapBlockMarker<?> m : MapDataInternal.getDynamicClient(mapId, mapData)) {
                var d = m.createDecorationFromMarker(mapData);
                if (d != null) {
                    decorations.put(m.getMarkerId(), d);
                }
            }
        }
    }

}
