package net.mehvahdjukaar.moonlight.core.mixins.forge;

import dev.architectury.patchedmixin.staticmixin.spongepowered.asm.mixin.Overwrite;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.forge.ExtraModelDataImpl;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import org.spongepowered.asm.mixin.Mixin;

import java.util.Objects;

@Mixin(IExtraModelDataProvider.class)
public interface SelfExtraModelDataProvider extends IForgeBlockEntity, IExtraModelDataProvider {

    //overwrite since it already has a default
    @Overwrite
    default void requestModelReload() {
        BlockEntity be = (BlockEntity) this;
        //marks model as dirty
        be.requestModelDataUpdate();
        var level = be.m_58904_();
        if (level != null && level.f_46443_) {
            //request re-render immediately
            level.m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), Block.f_152394_);
        }
    }

    @Override
    default ModelData getModelData() {
        if (this.getExtraModelData() instanceof ExtraModelDataImpl data) {
            return data.data();
        }
        return ModelData.EMPTY;
    }

    @Override
    default void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockEntity be = (BlockEntity) this;
        var level = be.m_58904_();
        if (level != null && level.f_46443_) {
            var oldData = this.getExtraModelData();
            CompoundTag tag = pkt.m_131708_();
            //this calls load
            if (tag != null) {
                be.m_142466_(tag);
                afterDataPacket(oldData);
            }
        }
    }

}
